@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiKey Unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgs(
    public val apiKey: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgs.builder()
            .apiKey(apiKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgsBuilder
internal constructor() {
    private var apiKey: Output<String>? = null

    /**
     * @param value Unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
     */
    @JvmName("txcaryfamdacscey")
    public suspend fun apiKey(`value`: Output<String>) {
        this.apiKey = value
    }

    /**
     * @param value Unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
     */
    @JvmName("uvrpaqwmngcobsar")
    public suspend fun apiKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgs(
            apiKey = apiKey ?: throw PulumiNullFieldException("apiKey"),
        )
}
