@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessToken The access token used to access the connector on your behalf.
 * @property clientId The identifier for the desired client.
 * @property clientSecret The client secret used by the OAuth client to authenticate to the authorization server.
 * @property oauthRequest Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgs(
    public val accessToken: Output<String>? = null,
    public val clientId: Output<String>,
    public val clientSecret: Output<String>,
    public val oauthRequest:
    Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskOauthRequestArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgs.builder()
            .accessToken(accessToken?.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret.applyValue({ args0 -> args0 }))
            .oauthRequest(oauthRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgsBuilder
internal constructor() {
    private var accessToken: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var oauthRequest:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskOauthRequestArgs>? =
        null

    /**
     * @param value The access token used to access the connector on your behalf.
     */
    @JvmName("edjqvfioqwrpufhm")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value The identifier for the desired client.
     */
    @JvmName("tfqepojcuasqcdel")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The client secret used by the OAuth client to authenticate to the authorization server.
     */
    @JvmName("xtmpjokeebgjkwvp")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
     */
    @JvmName("ubpkbgphsltsrycm")
    public suspend
    fun oauthRequest(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskOauthRequestArgs>) {
        this.oauthRequest = value
    }

    /**
     * @param value The access token used to access the connector on your behalf.
     */
    @JvmName("ttjrlhqqhjwifoml")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The identifier for the desired client.
     */
    @JvmName("vpnjaymklhmiflkt")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret used by the OAuth client to authenticate to the authorization server.
     */
    @JvmName("exwewlxoeasaefey")
    public suspend fun clientSecret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
     */
    @JvmName("ktefhvixagtiyjfw")
    public suspend
    fun oauthRequest(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskOauthRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauthRequest = mapped
    }

    /**
     * @param argument Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
     */
    @JvmName("mpggoekdutueoxkr")
    public suspend
    fun oauthRequest(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskOauthRequestArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskOauthRequestArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.oauthRequest = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgs(
            accessToken = accessToken,
            clientId = clientId ?: throw PulumiNullFieldException("clientId"),
            clientSecret = clientSecret ?: throw PulumiNullFieldException("clientSecret"),
            oauthRequest = oauthRequest,
        )
}
