@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property oauth2Properties The OAuth 2.0 properties required for OAuth 2.0 authentication.
 * @property profileProperties A map of properties that are required to create a profile for the custom connector.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgs(
    public val oauth2Properties:
    Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgs>? =
        null,
    public val profileProperties: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgs.builder()
            .oauth2Properties(oauth2Properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .profileProperties(
                profileProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgs].
 */
@PulumiTagMarker
public class
ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgsBuilder
internal constructor() {
    private var oauth2Properties:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgs>? =
        null

    private var profileProperties: Output<Map<String, String>>? = null

    /**
     * @param value The OAuth 2.0 properties required for OAuth 2.0 authentication.
     */
    @JvmName("vccywssvnyvvnsif")
    public suspend
    fun oauth2Properties(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgs>) {
        this.oauth2Properties = value
    }

    /**
     * @param value A map of properties that are required to create a profile for the custom connector.
     */
    @JvmName("yhcsvteplhlxcgiu")
    public suspend fun profileProperties(`value`: Output<Map<String, String>>) {
        this.profileProperties = value
    }

    /**
     * @param value The OAuth 2.0 properties required for OAuth 2.0 authentication.
     */
    @JvmName("sedttctfrvmeycqx")
    public suspend
    fun oauth2Properties(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauth2Properties = mapped
    }

    /**
     * @param argument The OAuth 2.0 properties required for OAuth 2.0 authentication.
     */
    @JvmName("nqleqpvlxsrjdrxg")
    public suspend
    fun oauth2Properties(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.oauth2Properties = mapped
    }

    /**
     * @param value A map of properties that are required to create a profile for the custom connector.
     */
    @JvmName("uxkqkngvobskdjqc")
    public suspend fun profileProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileProperties = mapped
    }

    /**
     * @param values A map of properties that are required to create a profile for the custom connector.
     */
    @JvmName("jcwhifccvoqyehjt")
    public fun profileProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profileProperties = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgs(
            oauth2Properties = oauth2Properties,
            profileProperties = profileProperties,
        )
}
