@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceUrl The location of the Datadog resource.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgs(
    public val instanceUrl: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgs.builder()
            .instanceUrl(instanceUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgsBuilder
internal constructor() {
    private var instanceUrl: Output<String>? = null

    /**
     * @param value The location of the Datadog resource.
     */
    @JvmName("txbshorvvlyxtlqa")
    public suspend fun instanceUrl(`value`: Output<String>) {
        this.instanceUrl = value
    }

    /**
     * @param value The location of the Datadog resource.
     */
    @JvmName("oxevkbaunscdqwol")
    public suspend fun instanceUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceUrl = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgs(
            instanceUrl = instanceUrl ?: throw PulumiNullFieldException("instanceUrl"),
        )
}
