@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property authCodeUrl The authorization code url required to redirect to SAP Login Page to fetch authorization code for OAuth type authentication.
 * @property oauthScopes The OAuth scopes required for OAuth type authentication.
 * @property tokenUrl The token URL required for OAuth 2.0 authentication.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgs(
    public val authCodeUrl: Output<String>,
    public val oauthScopes: Output<List<String>>,
    public val tokenUrl: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgs.builder()
            .authCodeUrl(authCodeUrl.applyValue({ args0 -> args0 }))
            .oauthScopes(oauthScopes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tokenUrl(tokenUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgs].
 */
@PulumiTagMarker
public class
ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgsBuilder
internal constructor() {
    private var authCodeUrl: Output<String>? = null

    private var oauthScopes: Output<List<String>>? = null

    private var tokenUrl: Output<String>? = null

    /**
     * @param value The authorization code url required to redirect to SAP Login Page to fetch authorization code for OAuth type authentication.
     */
    @JvmName("doojqxuncirrabdn")
    public suspend fun authCodeUrl(`value`: Output<String>) {
        this.authCodeUrl = value
    }

    /**
     * @param value The OAuth scopes required for OAuth type authentication.
     */
    @JvmName("kpgmkjekeisvjdfi")
    public suspend fun oauthScopes(`value`: Output<List<String>>) {
        this.oauthScopes = value
    }

    @JvmName("wrimlmfwranbyddu")
    public suspend fun oauthScopes(vararg values: Output<String>) {
        this.oauthScopes = Output.all(values.asList())
    }

    /**
     * @param values The OAuth scopes required for OAuth type authentication.
     */
    @JvmName("gbdyodypjxkyyhxx")
    public suspend fun oauthScopes(values: List<Output<String>>) {
        this.oauthScopes = Output.all(values)
    }

    /**
     * @param value The token URL required for OAuth 2.0 authentication.
     */
    @JvmName("swtdjjihtefklvrj")
    public suspend fun tokenUrl(`value`: Output<String>) {
        this.tokenUrl = value
    }

    /**
     * @param value The authorization code url required to redirect to SAP Login Page to fetch authorization code for OAuth type authentication.
     */
    @JvmName("kcwdpynxrgijujjg")
    public suspend fun authCodeUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authCodeUrl = mapped
    }

    /**
     * @param value The OAuth scopes required for OAuth type authentication.
     */
    @JvmName("xxpfmgeyapctbecu")
    public suspend fun oauthScopes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.oauthScopes = mapped
    }

    /**
     * @param values The OAuth scopes required for OAuth type authentication.
     */
    @JvmName("dcwltfrwmaustbet")
    public suspend fun oauthScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.oauthScopes = mapped
    }

    /**
     * @param value The token URL required for OAuth 2.0 authentication.
     */
    @JvmName("hvedqljhodpatewd")
    public suspend fun tokenUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenUrl = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgs(
            authCodeUrl = authCodeUrl ?: throw PulumiNullFieldException("authCodeUrl"),
            oauthScopes = oauthScopes ?: throw PulumiNullFieldException("oauthScopes"),
            tokenUrl = tokenUrl ?: throw PulumiNullFieldException("tokenUrl"),
        )
}
