@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceUrl The location of the Datadog resource.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgs(
    public val instanceUrl: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgs.builder()
            .instanceUrl(instanceUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgsBuilder
internal constructor() {
    private var instanceUrl: Output<String>? = null

    /**
     * @param value The location of the Datadog resource.
     */
    @JvmName("kqvljennpwwqlsga")
    public suspend fun instanceUrl(`value`: Output<String>) {
        this.instanceUrl = value
    }

    /**
     * @param value The location of the Datadog resource.
     */
    @JvmName("xtvbxwxlcgmrsjxs")
    public suspend fun instanceUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceUrl = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgs(
            instanceUrl = instanceUrl ?: throw PulumiNullFieldException("instanceUrl"),
        )
}
