@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the account.
 * @property bucketName A name for the associated Amazon S3 bucket.
 * @property bucketPrefix The object key for the destination bucket in which Amazon AppFlow places the files.
 * @property privateLinkServiceName The SAPOData Private Link service name to be used for private data transfers.
 * @property region AWS Region of the Snowflake account.
 * @property stage Name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account. This is written in the following format: `<Database>.<Schema>.<Stage Name>`.
 * @property warehouse The name of the Snowflake warehouse.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgs(
    public val accountName: Output<String>? = null,
    public val bucketName: Output<String>,
    public val bucketPrefix: Output<String>? = null,
    public val privateLinkServiceName: Output<String>? = null,
    public val region: Output<String>? = null,
    public val stage: Output<String>,
    public val warehouse: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .privateLinkServiceName(privateLinkServiceName?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .stage(stage.applyValue({ args0 -> args0 }))
            .warehouse(warehouse.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgsBuilder
internal constructor() {
    private var accountName: Output<String>? = null

    private var bucketName: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var privateLinkServiceName: Output<String>? = null

    private var region: Output<String>? = null

    private var stage: Output<String>? = null

    private var warehouse: Output<String>? = null

    /**
     * @param value The name of the account.
     */
    @JvmName("cpxtxediyuxoxuay")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value A name for the associated Amazon S3 bucket.
     */
    @JvmName("mwxceglecwkisnyy")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The object key for the destination bucket in which Amazon AppFlow places the files.
     */
    @JvmName("kjhfrmynyxcgreay")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value The SAPOData Private Link service name to be used for private data transfers.
     */
    @JvmName("eibyaqdrruydhnpq")
    public suspend fun privateLinkServiceName(`value`: Output<String>) {
        this.privateLinkServiceName = value
    }

    /**
     * @param value AWS Region of the Snowflake account.
     */
    @JvmName("folotwwykmstjsew")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account. This is written in the following format: `<Database>.<Schema>.<Stage Name>`.
     */
    @JvmName("rbqtpjtwapjgproh")
    public suspend fun stage(`value`: Output<String>) {
        this.stage = value
    }

    /**
     * @param value The name of the Snowflake warehouse.
     */
    @JvmName("tgotxitmhoiuggka")
    public suspend fun warehouse(`value`: Output<String>) {
        this.warehouse = value
    }

    /**
     * @param value The name of the account.
     */
    @JvmName("lqysvqwexuwlwflh")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value A name for the associated Amazon S3 bucket.
     */
    @JvmName("obgndwbrjtahcddb")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The object key for the destination bucket in which Amazon AppFlow places the files.
     */
    @JvmName("fanqqailnnckunyi")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value The SAPOData Private Link service name to be used for private data transfers.
     */
    @JvmName("vpsmnscmfyildkux")
    public suspend fun privateLinkServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceName = mapped
    }

    /**
     * @param value AWS Region of the Snowflake account.
     */
    @JvmName("enhyjpidbyshseea")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value Name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account. This is written in the following format: `<Database>.<Schema>.<Stage Name>`.
     */
    @JvmName("mhmrhvkwdhddyuqq")
    public suspend fun stage(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stage = mapped
    }

    /**
     * @param value The name of the Snowflake warehouse.
     */
    @JvmName("nlmxdwbirefxktmm")
    public suspend fun warehouse(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.warehouse = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgs(
            accountName = accountName,
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            bucketPrefix = bucketPrefix,
            privateLinkServiceName = privateLinkServiceName,
            region = region,
            stage = stage ?: throw PulumiNullFieldException("stage"),
            warehouse = warehouse ?: throw PulumiNullFieldException("warehouse"),
        )
}
