@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceUrl The location of the Datadog resource.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgs(
    public val instanceUrl: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgs.builder()
            .instanceUrl(instanceUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgsBuilder
internal constructor() {
    private var instanceUrl: Output<String>? = null

    /**
     * @param value The location of the Datadog resource.
     */
    @JvmName("ribxoeuemjkmdfos")
    public suspend fun instanceUrl(`value`: Output<String>) {
        this.instanceUrl = value
    }

    /**
     * @param value The location of the Datadog resource.
     */
    @JvmName("klmoggviyuksqasw")
    public suspend fun instanceUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceUrl = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgs(
            instanceUrl = instanceUrl ?: throw PulumiNullFieldException("instanceUrl"),
        )
}
