@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property apiVersion API version that the destination connector uses.
 * @property connectorProfileName Name of the connector profile. This name must be unique for each connector profile in the AWS account.
 * @property connectorType Type of connector, such as Salesforce, Amplitude, and so on. Valid values are `Salesforce`, `Singular`, `Slack`, `Redshift`, `S3`, `Marketo`, `Googleanalytics`, `Zendesk`, `Servicenow`, `Datadog`, `Trendmicro`, `Snowflake`, `Dynatrace`, `Infornexus`, `Amplitude`, `Veeva`, `EventBridge`, `LookoutMetrics`, `Upsolver`, `Honeycode`, `CustomerProfiles`, `SAPOData`, and `CustomConnector`.
 * @property destinationConnectorProperties This stores the information that is required to query a particular connector. See Destination Connector Properties for more information.
 */
public data class FlowDestinationFlowConfigArgs(
    public val apiVersion: Output<String>? = null,
    public val connectorProfileName: Output<String>? = null,
    public val connectorType: Output<String>,
    public val destinationConnectorProperties:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigArgs.builder()
            .apiVersion(apiVersion?.applyValue({ args0 -> args0 }))
            .connectorProfileName(connectorProfileName?.applyValue({ args0 -> args0 }))
            .connectorType(connectorType.applyValue({ args0 -> args0 }))
            .destinationConnectorProperties(
                destinationConnectorProperties.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [FlowDestinationFlowConfigArgs].
 */
@PulumiTagMarker
public class FlowDestinationFlowConfigArgsBuilder internal constructor() {
    private var apiVersion: Output<String>? = null

    private var connectorProfileName: Output<String>? = null

    private var connectorType: Output<String>? = null

    private var destinationConnectorProperties:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesArgs>? = null

    /**
     * @param value API version that the destination connector uses.
     */
    @JvmName("tprbgpfaljrcvdvm")
    public suspend fun apiVersion(`value`: Output<String>) {
        this.apiVersion = value
    }

    /**
     * @param value Name of the connector profile. This name must be unique for each connector profile in the AWS account.
     */
    @JvmName("guwwrndtcygguwxa")
    public suspend fun connectorProfileName(`value`: Output<String>) {
        this.connectorProfileName = value
    }

    /**
     * @param value Type of connector, such as Salesforce, Amplitude, and so on. Valid values are `Salesforce`, `Singular`, `Slack`, `Redshift`, `S3`, `Marketo`, `Googleanalytics`, `Zendesk`, `Servicenow`, `Datadog`, `Trendmicro`, `Snowflake`, `Dynatrace`, `Infornexus`, `Amplitude`, `Veeva`, `EventBridge`, `LookoutMetrics`, `Upsolver`, `Honeycode`, `CustomerProfiles`, `SAPOData`, and `CustomConnector`.
     */
    @JvmName("qylksehwkxktysrm")
    public suspend fun connectorType(`value`: Output<String>) {
        this.connectorType = value
    }

    /**
     * @param value This stores the information that is required to query a particular connector. See Destination Connector Properties for more information.
     */
    @JvmName("iodajiomavqxqcme")
    public suspend
    fun destinationConnectorProperties(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesArgs>) {
        this.destinationConnectorProperties = value
    }

    /**
     * @param value API version that the destination connector uses.
     */
    @JvmName("eledflqiyutrgnyp")
    public suspend fun apiVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersion = mapped
    }

    /**
     * @param value Name of the connector profile. This name must be unique for each connector profile in the AWS account.
     */
    @JvmName("mivcmjbygrdptjle")
    public suspend fun connectorProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorProfileName = mapped
    }

    /**
     * @param value Type of connector, such as Salesforce, Amplitude, and so on. Valid values are `Salesforce`, `Singular`, `Slack`, `Redshift`, `S3`, `Marketo`, `Googleanalytics`, `Zendesk`, `Servicenow`, `Datadog`, `Trendmicro`, `Snowflake`, `Dynatrace`, `Infornexus`, `Amplitude`, `Veeva`, `EventBridge`, `LookoutMetrics`, `Upsolver`, `Honeycode`, `CustomerProfiles`, `SAPOData`, and `CustomConnector`.
     */
    @JvmName("jgsnnkwaywpkuvqr")
    public suspend fun connectorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorType = mapped
    }

    /**
     * @param value This stores the information that is required to query a particular connector. See Destination Connector Properties for more information.
     */
    @JvmName("nbitgwhyqwsgxdlm")
    public suspend
    fun destinationConnectorProperties(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationConnectorProperties = mapped
    }

    /**
     * @param argument This stores the information that is required to query a particular connector. See Destination Connector Properties for more information.
     */
    @JvmName("swljsfuixwlpcqvl")
    public suspend
    fun destinationConnectorProperties(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.destinationConnectorProperties = mapped
    }

    internal fun build(): FlowDestinationFlowConfigArgs = FlowDestinationFlowConfigArgs(
        apiVersion = apiVersion,
        connectorProfileName = connectorProfileName,
        connectorType = connectorType ?: throw PulumiNullFieldException("connectorType"),
        destinationConnectorProperties = destinationConnectorProperties ?: throw
            PulumiNullFieldException("destinationConnectorProperties"),
    )
}
