@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customConnector Properties that are required to query the custom Connector. See Custom Connector Destination Properties for more details.
 * @property customerProfiles Properties that are required to query Amazon Connect Customer Profiles. See Customer Profiles Destination Properties for more details.
 * @property eventBridge Properties that are required to query Amazon EventBridge. See Generic Destination Properties for more details.
 * @property honeycode Properties that are required to query Amazon Honeycode. See Generic Destination Properties for more details.
 * @property lookoutMetrics
 * @property marketo Properties that are required to query Marketo. See Generic Destination Properties for more details.
 * @property redshift Properties that are required to query Amazon Redshift. See Redshift Destination Properties for more details.
 * @property s3 Properties that are required to query Amazon S3. See S3 Destination Properties for more details.
 * @property salesforce Properties that are required to query Salesforce. See Salesforce Destination Properties for more details.
 * @property sapoData Properties that are required to query SAPOData. See SAPOData Destination Properties for more details.
 * @property snowflake Properties that are required to query Snowflake. See Snowflake Destination Properties for more details.
 * @property upsolver Properties that are required to query Upsolver. See Upsolver Destination Properties for more details.
 * @property zendesk Properties that are required to query Zendesk. See Zendesk Destination Properties for more details.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesArgs(
    public val customConnector:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgs>? = null,
    public val customerProfiles:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgs>? = null,
    public val eventBridge:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgs>? = null,
    public val honeycode:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgs>? = null,
    public val lookoutMetrics:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesLookoutMetricsArgs>? = null,
    public val marketo: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesMarketoArgs>? =
        null,
    public val redshift: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs>? =
        null,
    public val s3: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args>? = null,
    public val salesforce:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgs>? = null,
    public val sapoData: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgs>? =
        null,
    public val snowflake:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSnowflakeArgs>? = null,
    public val upsolver: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgs>? =
        null,
    public val zendesk: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesZendeskArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesArgs.builder()
            .customConnector(customConnector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customerProfiles(customerProfiles?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventBridge(eventBridge?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .honeycode(honeycode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lookoutMetrics(lookoutMetrics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .marketo(marketo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .redshift(redshift?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3(s3?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .salesforce(salesforce?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sapoData(sapoData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .snowflake(snowflake?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .upsolver(upsolver?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zendesk(zendesk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesArgs].
 */
@PulumiTagMarker
public class FlowDestinationFlowConfigDestinationConnectorPropertiesArgsBuilder internal
constructor() {
    private var customConnector:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgs>? = null

    private var customerProfiles:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgs>? = null

    private var eventBridge:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgs>? = null

    private var honeycode:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgs>? = null

    private var lookoutMetrics:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesLookoutMetricsArgs>? = null

    private var marketo: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesMarketoArgs>? =
        null

    private var redshift: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs>? =
        null

    private var s3: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args>? = null

    private var salesforce:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgs>? = null

    private var sapoData: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgs>? =
        null

    private var snowflake:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSnowflakeArgs>? = null

    private var upsolver: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgs>? =
        null

    private var zendesk: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesZendeskArgs>? =
        null

    /**
     * @param value Properties that are required to query the custom Connector. See Custom Connector Destination Properties for more details.
     */
    @JvmName("bqxisvjqjjcvnccp")
    public suspend
    fun customConnector(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgs>) {
        this.customConnector = value
    }

    /**
     * @param value Properties that are required to query Amazon Connect Customer Profiles. See Customer Profiles Destination Properties for more details.
     */
    @JvmName("afgijagtqsumnhtk")
    public suspend
    fun customerProfiles(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgs>) {
        this.customerProfiles = value
    }

    /**
     * @param value Properties that are required to query Amazon EventBridge. See Generic Destination Properties for more details.
     */
    @JvmName("lotvphwqexxwbsel")
    public suspend
    fun eventBridge(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgs>) {
        this.eventBridge = value
    }

    /**
     * @param value Properties that are required to query Amazon Honeycode. See Generic Destination Properties for more details.
     */
    @JvmName("ygbnansmpsatfpuf")
    public suspend
    fun honeycode(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgs>) {
        this.honeycode = value
    }

    /**
     * @param value
     */
    @JvmName("crcvfbixkmhudpir")
    public suspend
    fun lookoutMetrics(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesLookoutMetricsArgs>) {
        this.lookoutMetrics = value
    }

    /**
     * @param value Properties that are required to query Marketo. See Generic Destination Properties for more details.
     */
    @JvmName("letswqibgfyfpcyv")
    public suspend
    fun marketo(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesMarketoArgs>) {
        this.marketo = value
    }

    /**
     * @param value Properties that are required to query Amazon Redshift. See Redshift Destination Properties for more details.
     */
    @JvmName("kybjyjebveweejam")
    public suspend
    fun redshift(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs>) {
        this.redshift = value
    }

    /**
     * @param value Properties that are required to query Amazon S3. See S3 Destination Properties for more details.
     */
    @JvmName("wyqmnuegmmxqcqdh")
    public suspend
    fun s3(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args>) {
        this.s3 = value
    }

    /**
     * @param value Properties that are required to query Salesforce. See Salesforce Destination Properties for more details.
     */
    @JvmName("ykxbdahwoudrxaxd")
    public suspend
    fun salesforce(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgs>) {
        this.salesforce = value
    }

    /**
     * @param value Properties that are required to query SAPOData. See SAPOData Destination Properties for more details.
     */
    @JvmName("fbigljovqpnociqt")
    public suspend
    fun sapoData(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgs>) {
        this.sapoData = value
    }

    /**
     * @param value Properties that are required to query Snowflake. See Snowflake Destination Properties for more details.
     */
    @JvmName("ldkactaxdwuwywao")
    public suspend
    fun snowflake(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSnowflakeArgs>) {
        this.snowflake = value
    }

    /**
     * @param value Properties that are required to query Upsolver. See Upsolver Destination Properties for more details.
     */
    @JvmName("jtqguflddwogijjl")
    public suspend
    fun upsolver(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgs>) {
        this.upsolver = value
    }

    /**
     * @param value Properties that are required to query Zendesk. See Zendesk Destination Properties for more details.
     */
    @JvmName("mlamwtlygrvbslgd")
    public suspend
    fun zendesk(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesZendeskArgs>) {
        this.zendesk = value
    }

    /**
     * @param value Properties that are required to query the custom Connector. See Custom Connector Destination Properties for more details.
     */
    @JvmName("hfxhrnkdhhrvwhrj")
    public suspend
    fun customConnector(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customConnector = mapped
    }

    /**
     * @param argument Properties that are required to query the custom Connector. See Custom Connector Destination Properties for more details.
     */
    @JvmName("skedxhwkyvdgeulk")
    public suspend
    fun customConnector(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customConnector = mapped
    }

    /**
     * @param value Properties that are required to query Amazon Connect Customer Profiles. See Customer Profiles Destination Properties for more details.
     */
    @JvmName("syceimemckhpqycn")
    public suspend
    fun customerProfiles(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerProfiles = mapped
    }

    /**
     * @param argument Properties that are required to query Amazon Connect Customer Profiles. See Customer Profiles Destination Properties for more details.
     */
    @JvmName("abgghqnlstobytgv")
    public suspend
    fun customerProfiles(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customerProfiles = mapped
    }

    /**
     * @param value Properties that are required to query Amazon EventBridge. See Generic Destination Properties for more details.
     */
    @JvmName("ktijfbmexknncbaj")
    public suspend
    fun eventBridge(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBridge = mapped
    }

    /**
     * @param argument Properties that are required to query Amazon EventBridge. See Generic Destination Properties for more details.
     */
    @JvmName("tyftuidthjsamrao")
    public suspend
    fun eventBridge(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.eventBridge = mapped
    }

    /**
     * @param value Properties that are required to query Amazon Honeycode. See Generic Destination Properties for more details.
     */
    @JvmName("jssffsfhbxudyoww")
    public suspend
    fun honeycode(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.honeycode = mapped
    }

    /**
     * @param argument Properties that are required to query Amazon Honeycode. See Generic Destination Properties for more details.
     */
    @JvmName("hjxgmumsybkhdkrk")
    public suspend
    fun honeycode(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.honeycode = mapped
    }

    /**
     * @param value
     */
    @JvmName("ynuvhkvqylaytwwp")
    public suspend
    fun lookoutMetrics(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesLookoutMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lookoutMetrics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lpmwbleghunwmdmy")
    public suspend
    fun lookoutMetrics(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesLookoutMetricsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesLookoutMetricsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.lookoutMetrics = mapped
    }

    /**
     * @param value Properties that are required to query Marketo. See Generic Destination Properties for more details.
     */
    @JvmName("bttehmbwxuhtpsxo")
    public suspend
    fun marketo(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesMarketoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketo = mapped
    }

    /**
     * @param argument Properties that are required to query Marketo. See Generic Destination Properties for more details.
     */
    @JvmName("osndjqbhainixwvd")
    public suspend
    fun marketo(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesMarketoArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesMarketoArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.marketo = mapped
    }

    /**
     * @param value Properties that are required to query Amazon Redshift. See Redshift Destination Properties for more details.
     */
    @JvmName("qssdlgjsfeuosgrl")
    public suspend
    fun redshift(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshift = mapped
    }

    /**
     * @param argument Properties that are required to query Amazon Redshift. See Redshift Destination Properties for more details.
     */
    @JvmName("bdgofcdmiravvfee")
    public suspend
    fun redshift(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.redshift = mapped
    }

    /**
     * @param value Properties that are required to query Amazon S3. See S3 Destination Properties for more details.
     */
    @JvmName("npfrkcakmhrkrbnr")
    public suspend fun s3(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument Properties that are required to query Amazon S3. See S3 Destination Properties for more details.
     */
    @JvmName("yllvodcnkpimkqnb")
    public suspend
    fun s3(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesS3ArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesS3ArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    /**
     * @param value Properties that are required to query Salesforce. See Salesforce Destination Properties for more details.
     */
    @JvmName("mtasaueogymexpvj")
    public suspend
    fun salesforce(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.salesforce = mapped
    }

    /**
     * @param argument Properties that are required to query Salesforce. See Salesforce Destination Properties for more details.
     */
    @JvmName("exiiledyicpcvqnt")
    public suspend
    fun salesforce(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.salesforce = mapped
    }

    /**
     * @param value Properties that are required to query SAPOData. See SAPOData Destination Properties for more details.
     */
    @JvmName("pwedewulccgkjlqr")
    public suspend
    fun sapoData(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapoData = mapped
    }

    /**
     * @param argument Properties that are required to query SAPOData. See SAPOData Destination Properties for more details.
     */
    @JvmName("uhbjaoouikcwkgvp")
    public suspend
    fun sapoData(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sapoData = mapped
    }

    /**
     * @param value Properties that are required to query Snowflake. See Snowflake Destination Properties for more details.
     */
    @JvmName("rvakxljfgluweblf")
    public suspend
    fun snowflake(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesSnowflakeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snowflake = mapped
    }

    /**
     * @param argument Properties that are required to query Snowflake. See Snowflake Destination Properties for more details.
     */
    @JvmName("rjvwbluvhigcdrnr")
    public suspend
    fun snowflake(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesSnowflakeArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesSnowflakeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.snowflake = mapped
    }

    /**
     * @param value Properties that are required to query Upsolver. See Upsolver Destination Properties for more details.
     */
    @JvmName("idxmsyjwhwbdvyxf")
    public suspend
    fun upsolver(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upsolver = mapped
    }

    /**
     * @param argument Properties that are required to query Upsolver. See Upsolver Destination Properties for more details.
     */
    @JvmName("jbuewrloesvpqnhq")
    public suspend
    fun upsolver(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.upsolver = mapped
    }

    /**
     * @param value Properties that are required to query Zendesk. See Zendesk Destination Properties for more details.
     */
    @JvmName("vkbeyxlgsmoqnxdp")
    public suspend
    fun zendesk(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesZendeskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zendesk = mapped
    }

    /**
     * @param argument Properties that are required to query Zendesk. See Zendesk Destination Properties for more details.
     */
    @JvmName("atjtcebqmpnldvrj")
    public suspend
    fun zendesk(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesZendeskArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesZendeskArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.zendesk = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesArgs(
            customConnector = customConnector,
            customerProfiles = customerProfiles,
            eventBridge = eventBridge,
            honeycode = honeycode,
            lookoutMetrics = lookoutMetrics,
            marketo = marketo,
            redshift = redshift,
            s3 = s3,
            salesforce = salesforce,
            sapoData = sapoData,
            snowflake = snowflake,
            upsolver = upsolver,
            zendesk = zendesk,
        )
}
