@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property customProperties Custom properties that are specific to the connector when it's used as a destination in the flow. Maximum of 50 items.
 * @property entityName Entity specified in the custom connector as a destination in the flow.
 * @property errorHandlingConfig Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
 * @property idFieldNames Name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
 * @property writeOperationType Type of write operation to be performed in the custom connector when it's used as destination. Valid values are `INSERT`, `UPSERT`, `UPDATE`, and `DELETE`.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgs(
    public val customProperties: Output<Map<String, String>>? = null,
    public val entityName: Output<String>,
    public val errorHandlingConfig:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorErrorHandlingConfigArgs>? =
        null,
    public val idFieldNames: Output<List<String>>? = null,
    public val writeOperationType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgs.builder()
            .customProperties(
                customProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .entityName(entityName.applyValue({ args0 -> args0 }))
            .errorHandlingConfig(
                errorHandlingConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .idFieldNames(idFieldNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .writeOperationType(writeOperationType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgs].
 */
@PulumiTagMarker
public class FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgsBuilder
internal constructor() {
    private var customProperties: Output<Map<String, String>>? = null

    private var entityName: Output<String>? = null

    private var errorHandlingConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorErrorHandlingConfigArgs>? =
        null

    private var idFieldNames: Output<List<String>>? = null

    private var writeOperationType: Output<String>? = null

    /**
     * @param value Custom properties that are specific to the connector when it's used as a destination in the flow. Maximum of 50 items.
     */
    @JvmName("otwwymvaswqokxnd")
    public suspend fun customProperties(`value`: Output<Map<String, String>>) {
        this.customProperties = value
    }

    /**
     * @param value Entity specified in the custom connector as a destination in the flow.
     */
    @JvmName("ymoyymeejxodkmhn")
    public suspend fun entityName(`value`: Output<String>) {
        this.entityName = value
    }

    /**
     * @param value Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("gdicgwycqrvrhhal")
    public suspend
    fun errorHandlingConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorErrorHandlingConfigArgs>) {
        this.errorHandlingConfig = value
    }

    /**
     * @param value Name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
     */
    @JvmName("dgpwppvybxkxvccn")
    public suspend fun idFieldNames(`value`: Output<List<String>>) {
        this.idFieldNames = value
    }

    @JvmName("tonqxkmdlvustjdo")
    public suspend fun idFieldNames(vararg values: Output<String>) {
        this.idFieldNames = Output.all(values.asList())
    }

    /**
     * @param values Name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
     */
    @JvmName("rxqluwrmjjjcdviq")
    public suspend fun idFieldNames(values: List<Output<String>>) {
        this.idFieldNames = Output.all(values)
    }

    /**
     * @param value Type of write operation to be performed in the custom connector when it's used as destination. Valid values are `INSERT`, `UPSERT`, `UPDATE`, and `DELETE`.
     */
    @JvmName("qdjxgefwygnuokyn")
    public suspend fun writeOperationType(`value`: Output<String>) {
        this.writeOperationType = value
    }

    /**
     * @param value Custom properties that are specific to the connector when it's used as a destination in the flow. Maximum of 50 items.
     */
    @JvmName("wtsinegcttmlohmk")
    public suspend fun customProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param values Custom properties that are specific to the connector when it's used as a destination in the flow. Maximum of 50 items.
     */
    @JvmName("tbeunqdoumokhtgo")
    public fun customProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Entity specified in the custom connector as a destination in the flow.
     */
    @JvmName("nmmbexhmjexfoqjo")
    public suspend fun entityName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entityName = mapped
    }

    /**
     * @param value Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("pscwgkcksrmqewgb")
    public suspend
    fun errorHandlingConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorErrorHandlingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorHandlingConfig = mapped
    }

    /**
     * @param argument Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("lchfnjpfciltyqlw")
    public suspend
    fun errorHandlingConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorErrorHandlingConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorErrorHandlingConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.errorHandlingConfig = mapped
    }

    /**
     * @param value Name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
     */
    @JvmName("bnbdrfkilfhsqglw")
    public suspend fun idFieldNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idFieldNames = mapped
    }

    /**
     * @param values Name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
     */
    @JvmName("ywxdvkiubpnpfhsb")
    public suspend fun idFieldNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.idFieldNames = mapped
    }

    /**
     * @param value Type of write operation to be performed in the custom connector when it's used as destination. Valid values are `INSERT`, `UPSERT`, `UPDATE`, and `DELETE`.
     */
    @JvmName("lxrliapxxiqgthgt")
    public suspend fun writeOperationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeOperationType = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorArgs(
            customProperties = customProperties,
            entityName = entityName ?: throw PulumiNullFieldException("entityName"),
            errorHandlingConfig = errorHandlingConfig,
            idFieldNames = idFieldNames,
            writeOperationType = writeOperationType,
        )
}
