@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName Unique name of the Amazon Connect Customer Profiles domain.
 * @property objectTypeName Object specified in the Amazon Connect Customer Profiles flow destination.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgs(
    public val domainName: Output<String>,
    public val objectTypeName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgs.builder()
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .objectTypeName(objectTypeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgs].
 */
@PulumiTagMarker
public class FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgsBuilder
internal constructor() {
    private var domainName: Output<String>? = null

    private var objectTypeName: Output<String>? = null

    /**
     * @param value Unique name of the Amazon Connect Customer Profiles domain.
     */
    @JvmName("pwwyseetqfmphbxy")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Object specified in the Amazon Connect Customer Profiles flow destination.
     */
    @JvmName("pnwtlnkblyjsouuc")
    public suspend fun objectTypeName(`value`: Output<String>) {
        this.objectTypeName = value
    }

    /**
     * @param value Unique name of the Amazon Connect Customer Profiles domain.
     */
    @JvmName("hhnefxytclbtvngv")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Object specified in the Amazon Connect Customer Profiles flow destination.
     */
    @JvmName("lfifgbrkskylylcj")
    public suspend fun objectTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectTypeName = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfilesArgs(
            domainName = domainName ?: throw PulumiNullFieldException("domainName"),
            objectTypeName = objectTypeName,
        )
}
