@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property errorHandlingConfig Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
 * @property object Object specified in the flow destination.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgs(
    public val errorHandlingConfig:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeErrorHandlingConfigArgs>? =
        null,
    public val `object`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgs.builder()
            .errorHandlingConfig(
                errorHandlingConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .`object`(`object`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgs].
 */
@PulumiTagMarker
public class FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgsBuilder internal
constructor() {
    private var errorHandlingConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeErrorHandlingConfigArgs>? =
        null

    private var `object`: Output<String>? = null

    /**
     * @param value Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("pqfatnovjrhwhtuj")
    public suspend
    fun errorHandlingConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeErrorHandlingConfigArgs>) {
        this.errorHandlingConfig = value
    }

    /**
     * @param value Object specified in the flow destination.
     */
    @JvmName("pfrnfwlmagtxjuku")
    public suspend fun `object`(`value`: Output<String>) {
        this.`object` = value
    }

    /**
     * @param value Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("lkeerfbmiruwlkla")
    public suspend
    fun errorHandlingConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeErrorHandlingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorHandlingConfig = mapped
    }

    /**
     * @param argument Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("yxdmfuofxowwlxjh")
    public suspend
    fun errorHandlingConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeErrorHandlingConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeErrorHandlingConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.errorHandlingConfig = mapped
    }

    /**
     * @param value Object specified in the flow destination.
     */
    @JvmName("ujgqnuxvschlrknv")
    public suspend fun `object`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`object` = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridgeArgs(
            errorHandlingConfig = errorHandlingConfig,
            `object` = `object` ?: throw PulumiNullFieldException("object"),
        )
}
