@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property errorHandlingConfig Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
 * @property object Object specified in the flow destination.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgs(
    public val errorHandlingConfig:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeErrorHandlingConfigArgs>? =
        null,
    public val `object`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgs.builder()
            .errorHandlingConfig(
                errorHandlingConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .`object`(`object`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgs].
 */
@PulumiTagMarker
public class FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgsBuilder internal
constructor() {
    private var errorHandlingConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeErrorHandlingConfigArgs>? =
        null

    private var `object`: Output<String>? = null

    /**
     * @param value Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("uoqyfkqsexhrfdic")
    public suspend
    fun errorHandlingConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeErrorHandlingConfigArgs>) {
        this.errorHandlingConfig = value
    }

    /**
     * @param value Object specified in the flow destination.
     */
    @JvmName("unaiqwwvunjulttr")
    public suspend fun `object`(`value`: Output<String>) {
        this.`object` = value
    }

    /**
     * @param value Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("voahobvsllkaexxm")
    public suspend
    fun errorHandlingConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeErrorHandlingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorHandlingConfig = mapped
    }

    /**
     * @param argument Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("icbvpywqrqhnhcdy")
    public suspend
    fun errorHandlingConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeErrorHandlingConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeErrorHandlingConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.errorHandlingConfig = mapped
    }

    /**
     * @param value Object specified in the flow destination.
     */
    @JvmName("nixtfsyucbkdfchq")
    public suspend fun `object`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`object` = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeArgs(
            errorHandlingConfig = errorHandlingConfig,
            `object` = `object` ?: throw PulumiNullFieldException("object"),
        )
}
