@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bucketPrefix Amazon S3 bucket prefix.
 * @property errorHandlingConfig Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
 * @property intermediateBucketName Intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift.
 * @property object Object specified in the flow destination.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs(
    public val bucketPrefix: Output<String>? = null,
    public val errorHandlingConfig:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs>? =
        null,
    public val intermediateBucketName: Output<String>,
    public val `object`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs.builder()
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .errorHandlingConfig(
                errorHandlingConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .intermediateBucketName(intermediateBucketName.applyValue({ args0 -> args0 }))
            .`object`(`object`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs].
 */
@PulumiTagMarker
public class FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgsBuilder internal
constructor() {
    private var bucketPrefix: Output<String>? = null

    private var errorHandlingConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs>? =
        null

    private var intermediateBucketName: Output<String>? = null

    private var `object`: Output<String>? = null

    /**
     * @param value Amazon S3 bucket prefix.
     */
    @JvmName("ikrwmydivyssaqry")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("dnsldiuejvwxceap")
    public suspend
    fun errorHandlingConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs>) {
        this.errorHandlingConfig = value
    }

    /**
     * @param value Intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift.
     */
    @JvmName("aemscxeelddcecqd")
    public suspend fun intermediateBucketName(`value`: Output<String>) {
        this.intermediateBucketName = value
    }

    /**
     * @param value Object specified in the flow destination.
     */
    @JvmName("pvugwvlbebvotbrb")
    public suspend fun `object`(`value`: Output<String>) {
        this.`object` = value
    }

    /**
     * @param value Amazon S3 bucket prefix.
     */
    @JvmName("ywjygoswrvclovpb")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("uqkhipsxegmftxqh")
    public suspend
    fun errorHandlingConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorHandlingConfig = mapped
    }

    /**
     * @param argument Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("rdvoownwoxlqjlox")
    public suspend
    fun errorHandlingConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.errorHandlingConfig = mapped
    }

    /**
     * @param value Intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift.
     */
    @JvmName("egcpsdcgjrrbldyw")
    public suspend fun intermediateBucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.intermediateBucketName = mapped
    }

    /**
     * @param value Object specified in the flow destination.
     */
    @JvmName("exynkjuleudyevwq")
    public suspend fun `object`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`object` = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs(
            bucketPrefix = bucketPrefix,
            errorHandlingConfig = errorHandlingConfig,
            intermediateBucketName = intermediateBucketName ?: throw
                PulumiNullFieldException("intermediateBucketName"),
            `object` = `object` ?: throw PulumiNullFieldException("object"),
        )
}
