@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName Name of the Amazon S3 bucket.
 * @property bucketPrefix Amazon S3 bucket prefix.
 * @property failOnFirstDestinationError If the flow should fail after the first instance of a failure when attempting to place data in the destination.
 */
public data class
FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs(
    public val bucketName: Output<String>? = null,
    public val bucketPrefix: Output<String>? = null,
    public val failOnFirstDestinationError: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .failOnFirstDestinationError(failOnFirstDestinationError?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs].
 */
@PulumiTagMarker
public class
FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgsBuilder
internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var failOnFirstDestinationError: Output<Boolean>? = null

    /**
     * @param value Name of the Amazon S3 bucket.
     */
    @JvmName("febptsbsfkddtaio")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Amazon S3 bucket prefix.
     */
    @JvmName("qhuspubgbglfmbap")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value If the flow should fail after the first instance of a failure when attempting to place data in the destination.
     */
    @JvmName("fwyjxfeixpickdkx")
    public suspend fun failOnFirstDestinationError(`value`: Output<Boolean>) {
        this.failOnFirstDestinationError = value
    }

    /**
     * @param value Name of the Amazon S3 bucket.
     */
    @JvmName("bjaujablbxtmantm")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Amazon S3 bucket prefix.
     */
    @JvmName("boynlmsmyawutxwv")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value If the flow should fail after the first instance of a failure when attempting to place data in the destination.
     */
    @JvmName("fdchoxibyhflljul")
    public suspend fun failOnFirstDestinationError(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failOnFirstDestinationError = mapped
    }

    internal fun build():
        FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs(
            bucketName = bucketName,
            bucketPrefix = bucketPrefix,
            failOnFirstDestinationError = failOnFirstDestinationError,
        )
}
