@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property errorHandlingConfig Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
 * @property idFieldNames Name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
 * @property object Object specified in the flow destination.
 * @property writeOperationType Type of write operation to be performed in the custom connector when it's used as destination. Valid values are `INSERT`, `UPSERT`, `UPDATE`, and `DELETE`.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgs(
    public val errorHandlingConfig:
    Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceErrorHandlingConfigArgs>? =
        null,
    public val idFieldNames: Output<List<String>>? = null,
    public val `object`: Output<String>,
    public val writeOperationType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgs.builder()
            .errorHandlingConfig(
                errorHandlingConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .idFieldNames(idFieldNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .`object`(`object`.applyValue({ args0 -> args0 }))
            .writeOperationType(writeOperationType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgs].
 */
@PulumiTagMarker
public class FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgsBuilder internal
constructor() {
    private var errorHandlingConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceErrorHandlingConfigArgs>? =
        null

    private var idFieldNames: Output<List<String>>? = null

    private var `object`: Output<String>? = null

    private var writeOperationType: Output<String>? = null

    /**
     * @param value Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("wyjunlnockqyyppf")
    public suspend
    fun errorHandlingConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceErrorHandlingConfigArgs>) {
        this.errorHandlingConfig = value
    }

    /**
     * @param value Name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
     */
    @JvmName("qqcenjymfehhppym")
    public suspend fun idFieldNames(`value`: Output<List<String>>) {
        this.idFieldNames = value
    }

    @JvmName("ixyftyoifefskjxb")
    public suspend fun idFieldNames(vararg values: Output<String>) {
        this.idFieldNames = Output.all(values.asList())
    }

    /**
     * @param values Name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
     */
    @JvmName("jxdurqalqqvvdvkl")
    public suspend fun idFieldNames(values: List<Output<String>>) {
        this.idFieldNames = Output.all(values)
    }

    /**
     * @param value Object specified in the flow destination.
     */
    @JvmName("vqbemlsmxjdcogph")
    public suspend fun `object`(`value`: Output<String>) {
        this.`object` = value
    }

    /**
     * @param value Type of write operation to be performed in the custom connector when it's used as destination. Valid values are `INSERT`, `UPSERT`, `UPDATE`, and `DELETE`.
     */
    @JvmName("eamfquwxucemsaow")
    public suspend fun writeOperationType(`value`: Output<String>) {
        this.writeOperationType = value
    }

    /**
     * @param value Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("ivbpccrdwehhkesn")
    public suspend
    fun errorHandlingConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceErrorHandlingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorHandlingConfig = mapped
    }

    /**
     * @param argument Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
     */
    @JvmName("sonxaaldvaoxnxnv")
    public suspend
    fun errorHandlingConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceErrorHandlingConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceErrorHandlingConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.errorHandlingConfig = mapped
    }

    /**
     * @param value Name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
     */
    @JvmName("adhenwnwdpvfvyip")
    public suspend fun idFieldNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idFieldNames = mapped
    }

    /**
     * @param values Name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
     */
    @JvmName("svdfcvatagkqtpaa")
    public suspend fun idFieldNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.idFieldNames = mapped
    }

    /**
     * @param value Object specified in the flow destination.
     */
    @JvmName("xfcqcxocpapuymnh")
    public suspend fun `object`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`object` = mapped
    }

    /**
     * @param value Type of write operation to be performed in the custom connector when it's used as destination. Valid values are `INSERT`, `UPSERT`, `UPDATE`, and `DELETE`.
     */
    @JvmName("xxqjkrdxiumctvac")
    public suspend fun writeOperationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeOperationType = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceArgs(
            errorHandlingConfig = errorHandlingConfig,
            idFieldNames = idFieldNames,
            `object` = `object` ?: throw PulumiNullFieldException("object"),
            writeOperationType = writeOperationType,
        )
}
