@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property apiVersion API version that the destination connector uses.
 * @property connectorProfileName Name of the connector profile. This name must be unique for each connector profile in the AWS account.
 * @property connectorType Type of connector, such as Salesforce, Amplitude, and so on. Valid values are `Salesforce`, `Singular`, `Slack`, `Redshift`, `S3`, `Marketo`, `Googleanalytics`, `Zendesk`, `Servicenow`, `Datadog`, `Trendmicro`, `Snowflake`, `Dynatrace`, `Infornexus`, `Amplitude`, `Veeva`, `EventBridge`, `LookoutMetrics`, `Upsolver`, `Honeycode`, `CustomerProfiles`, `SAPOData`, and `CustomConnector`.
 * @property incrementalPullConfig Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull. See Incremental Pull Config for more details.
 * @property sourceConnectorProperties Information that is required to query a particular source connector. See Source Connector Properties for details.
 */
public data class FlowSourceFlowConfigArgs(
    public val apiVersion: Output<String>? = null,
    public val connectorProfileName: Output<String>? = null,
    public val connectorType: Output<String>,
    public val incrementalPullConfig: Output<FlowSourceFlowConfigIncrementalPullConfigArgs>? = null,
    public val sourceConnectorProperties: Output<FlowSourceFlowConfigSourceConnectorPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigArgs =
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigArgs.builder()
            .apiVersion(apiVersion?.applyValue({ args0 -> args0 }))
            .connectorProfileName(connectorProfileName?.applyValue({ args0 -> args0 }))
            .connectorType(connectorType.applyValue({ args0 -> args0 }))
            .incrementalPullConfig(
                incrementalPullConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sourceConnectorProperties(
                sourceConnectorProperties.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FlowSourceFlowConfigArgs].
 */
@PulumiTagMarker
public class FlowSourceFlowConfigArgsBuilder internal constructor() {
    private var apiVersion: Output<String>? = null

    private var connectorProfileName: Output<String>? = null

    private var connectorType: Output<String>? = null

    private var incrementalPullConfig: Output<FlowSourceFlowConfigIncrementalPullConfigArgs>? = null

    private var sourceConnectorProperties: Output<FlowSourceFlowConfigSourceConnectorPropertiesArgs>? =
        null

    /**
     * @param value API version that the destination connector uses.
     */
    @JvmName("omddekxsyorqjotd")
    public suspend fun apiVersion(`value`: Output<String>) {
        this.apiVersion = value
    }

    /**
     * @param value Name of the connector profile. This name must be unique for each connector profile in the AWS account.
     */
    @JvmName("btdewuhyraxfxkqw")
    public suspend fun connectorProfileName(`value`: Output<String>) {
        this.connectorProfileName = value
    }

    /**
     * @param value Type of connector, such as Salesforce, Amplitude, and so on. Valid values are `Salesforce`, `Singular`, `Slack`, `Redshift`, `S3`, `Marketo`, `Googleanalytics`, `Zendesk`, `Servicenow`, `Datadog`, `Trendmicro`, `Snowflake`, `Dynatrace`, `Infornexus`, `Amplitude`, `Veeva`, `EventBridge`, `LookoutMetrics`, `Upsolver`, `Honeycode`, `CustomerProfiles`, `SAPOData`, and `CustomConnector`.
     */
    @JvmName("sbchnbkgxaefiwnb")
    public suspend fun connectorType(`value`: Output<String>) {
        this.connectorType = value
    }

    /**
     * @param value Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull. See Incremental Pull Config for more details.
     */
    @JvmName("ovcwforelydnodyp")
    public suspend
    fun incrementalPullConfig(`value`: Output<FlowSourceFlowConfigIncrementalPullConfigArgs>) {
        this.incrementalPullConfig = value
    }

    /**
     * @param value Information that is required to query a particular source connector. See Source Connector Properties for details.
     */
    @JvmName("qqjsdhxntqhydsqq")
    public suspend
    fun sourceConnectorProperties(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesArgs>) {
        this.sourceConnectorProperties = value
    }

    /**
     * @param value API version that the destination connector uses.
     */
    @JvmName("gbgjhenuecvejyhf")
    public suspend fun apiVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersion = mapped
    }

    /**
     * @param value Name of the connector profile. This name must be unique for each connector profile in the AWS account.
     */
    @JvmName("pkdtahjaacadbqcw")
    public suspend fun connectorProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorProfileName = mapped
    }

    /**
     * @param value Type of connector, such as Salesforce, Amplitude, and so on. Valid values are `Salesforce`, `Singular`, `Slack`, `Redshift`, `S3`, `Marketo`, `Googleanalytics`, `Zendesk`, `Servicenow`, `Datadog`, `Trendmicro`, `Snowflake`, `Dynatrace`, `Infornexus`, `Amplitude`, `Veeva`, `EventBridge`, `LookoutMetrics`, `Upsolver`, `Honeycode`, `CustomerProfiles`, `SAPOData`, and `CustomConnector`.
     */
    @JvmName("sivfabmvftohnibr")
    public suspend fun connectorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorType = mapped
    }

    /**
     * @param value Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull. See Incremental Pull Config for more details.
     */
    @JvmName("pyhwcnhwlffaghtl")
    public suspend
    fun incrementalPullConfig(`value`: FlowSourceFlowConfigIncrementalPullConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incrementalPullConfig = mapped
    }

    /**
     * @param argument Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull. See Incremental Pull Config for more details.
     */
    @JvmName("iyltvserdmwacjck")
    public suspend
    fun incrementalPullConfig(argument: suspend FlowSourceFlowConfigIncrementalPullConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FlowSourceFlowConfigIncrementalPullConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.incrementalPullConfig = mapped
    }

    /**
     * @param value Information that is required to query a particular source connector. See Source Connector Properties for details.
     */
    @JvmName("mdaiyvspydbffmku")
    public suspend
    fun sourceConnectorProperties(`value`: FlowSourceFlowConfigSourceConnectorPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectorProperties = mapped
    }

    /**
     * @param argument Information that is required to query a particular source connector. See Source Connector Properties for details.
     */
    @JvmName("ipbdifwvsgjdkmak")
    public suspend
    fun sourceConnectorProperties(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = FlowSourceFlowConfigSourceConnectorPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectorProperties = mapped
    }

    internal fun build(): FlowSourceFlowConfigArgs = FlowSourceFlowConfigArgs(
        apiVersion = apiVersion,
        connectorProfileName = connectorProfileName,
        connectorType = connectorType ?: throw PulumiNullFieldException("connectorType"),
        incrementalPullConfig = incrementalPullConfig,
        sourceConnectorProperties = sourceConnectorProperties ?: throw
            PulumiNullFieldException("sourceConnectorProperties"),
    )
}
