@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigIncrementalPullConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property datetimeTypeFieldName Field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
 */
public data class FlowSourceFlowConfigIncrementalPullConfigArgs(
    public val datetimeTypeFieldName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigIncrementalPullConfigArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigIncrementalPullConfigArgs =
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigIncrementalPullConfigArgs.builder()
            .datetimeTypeFieldName(datetimeTypeFieldName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowSourceFlowConfigIncrementalPullConfigArgs].
 */
@PulumiTagMarker
public class FlowSourceFlowConfigIncrementalPullConfigArgsBuilder internal constructor() {
    private var datetimeTypeFieldName: Output<String>? = null

    /**
     * @param value Field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
     */
    @JvmName("lfqsjnxqurdewpaf")
    public suspend fun datetimeTypeFieldName(`value`: Output<String>) {
        this.datetimeTypeFieldName = value
    }

    /**
     * @param value Field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
     */
    @JvmName("keacpsbtfprbsera")
    public suspend fun datetimeTypeFieldName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datetimeTypeFieldName = mapped
    }

    internal fun build(): FlowSourceFlowConfigIncrementalPullConfigArgs =
        FlowSourceFlowConfigIncrementalPullConfigArgs(
            datetimeTypeFieldName = datetimeTypeFieldName,
        )
}
