@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property amplitude Information that is required for querying Amplitude. See Generic Source Properties for more details.
 * @property customConnector Properties that are applied when the custom connector is being used as a source. See Custom Connector Source Properties.
 * @property datadog Information that is required for querying Datadog. See Generic Source Properties for more details.
 * @property dynatrace Operation to be performed on the provided Dynatrace source fields. Valid values are `PROJECTION`, `BETWEEN`, `EQUAL_TO`, `ADDITION`, `MULTIPLICATION`, `DIVISION`, `SUBTRACTION`, `MASK_ALL`, `MASK_FIRST_N`, `MASK_LAST_N`, `VALIDATE_NON_NULL`, `VALIDATE_NON_ZERO`, `VALIDATE_NON_NEGATIVE`, `VALIDATE_NUMERIC`, and `NO_OP`.
 * @property googleAnalytics Operation to be performed on the provided Google Analytics source fields. Valid values are `PROJECTION` and `BETWEEN`.
 * @property inforNexus Information that is required for querying Infor Nexus. See Generic Source Properties for more details.
 * @property marketo Information that is required for querying Marketo. See Generic Source Properties for more details.
 * @property s3 Information that is required for querying Amazon S3. See S3 Source Properties for more details.
 * @property salesforce Information that is required for querying Salesforce. See Salesforce Source Properties for more details.
 * @property sapoData Information that is required for querying SAPOData as a flow source. See SAPO Source Properties for more details.
 * @property serviceNow Information that is required for querying ServiceNow. See Generic Source Properties for more details.
 * @property singular Information that is required for querying Singular. See Generic Source Properties for more details.
 * @property slack Information that is required for querying Slack. See Generic Source Properties for more details.
 * @property trendmicro Operation to be performed on the provided Trend Micro source fields. Valid values are `PROJECTION`, `EQUAL_TO`, `ADDITION`, `MULTIPLICATION`, `DIVISION`, `SUBTRACTION`, `MASK_ALL`, `MASK_FIRST_N`, `MASK_LAST_N`, `VALIDATE_NON_NULL`, `VALIDATE_NON_ZERO`, `VALIDATE_NON_NEGATIVE`, `VALIDATE_NUMERIC`, and `NO_OP`.
 * @property veeva Information that is required for querying Veeva. See Veeva Source Properties for more details.
 * @property zendesk Information that is required for querying Zendesk. See Generic Source Properties for more details.
 */
public data class FlowSourceFlowConfigSourceConnectorPropertiesArgs(
    public val amplitude: Output<FlowSourceFlowConfigSourceConnectorPropertiesAmplitudeArgs>? = null,
    public val customConnector:
    Output<FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgs>? = null,
    public val datadog: Output<FlowSourceFlowConfigSourceConnectorPropertiesDatadogArgs>? = null,
    public val dynatrace: Output<FlowSourceFlowConfigSourceConnectorPropertiesDynatraceArgs>? = null,
    public val googleAnalytics:
    Output<FlowSourceFlowConfigSourceConnectorPropertiesGoogleAnalyticsArgs>? = null,
    public val inforNexus: Output<FlowSourceFlowConfigSourceConnectorPropertiesInforNexusArgs>? =
        null,
    public val marketo: Output<FlowSourceFlowConfigSourceConnectorPropertiesMarketoArgs>? = null,
    public val s3: Output<FlowSourceFlowConfigSourceConnectorPropertiesS3Args>? = null,
    public val salesforce: Output<FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgs>? =
        null,
    public val sapoData: Output<FlowSourceFlowConfigSourceConnectorPropertiesSapoDataArgs>? = null,
    public val serviceNow: Output<FlowSourceFlowConfigSourceConnectorPropertiesServiceNowArgs>? =
        null,
    public val singular: Output<FlowSourceFlowConfigSourceConnectorPropertiesSingularArgs>? = null,
    public val slack: Output<FlowSourceFlowConfigSourceConnectorPropertiesSlackArgs>? = null,
    public val trendmicro: Output<FlowSourceFlowConfigSourceConnectorPropertiesTrendmicroArgs>? =
        null,
    public val veeva: Output<FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgs>? = null,
    public val zendesk: Output<FlowSourceFlowConfigSourceConnectorPropertiesZendeskArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesArgs =
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesArgs.builder()
            .amplitude(amplitude?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customConnector(customConnector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .datadog(datadog?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dynatrace(dynatrace?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .googleAnalytics(googleAnalytics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inforNexus(inforNexus?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .marketo(marketo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3(s3?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .salesforce(salesforce?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sapoData(sapoData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceNow(serviceNow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singular(singular?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .slack(slack?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trendmicro(trendmicro?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .veeva(veeva?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zendesk(zendesk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FlowSourceFlowConfigSourceConnectorPropertiesArgs].
 */
@PulumiTagMarker
public class FlowSourceFlowConfigSourceConnectorPropertiesArgsBuilder internal constructor() {
    private var amplitude: Output<FlowSourceFlowConfigSourceConnectorPropertiesAmplitudeArgs>? = null

    private var customConnector:
        Output<FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgs>? = null

    private var datadog: Output<FlowSourceFlowConfigSourceConnectorPropertiesDatadogArgs>? = null

    private var dynatrace: Output<FlowSourceFlowConfigSourceConnectorPropertiesDynatraceArgs>? = null

    private var googleAnalytics:
        Output<FlowSourceFlowConfigSourceConnectorPropertiesGoogleAnalyticsArgs>? = null

    private var inforNexus: Output<FlowSourceFlowConfigSourceConnectorPropertiesInforNexusArgs>? =
        null

    private var marketo: Output<FlowSourceFlowConfigSourceConnectorPropertiesMarketoArgs>? = null

    private var s3: Output<FlowSourceFlowConfigSourceConnectorPropertiesS3Args>? = null

    private var salesforce: Output<FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgs>? =
        null

    private var sapoData: Output<FlowSourceFlowConfigSourceConnectorPropertiesSapoDataArgs>? = null

    private var serviceNow: Output<FlowSourceFlowConfigSourceConnectorPropertiesServiceNowArgs>? =
        null

    private var singular: Output<FlowSourceFlowConfigSourceConnectorPropertiesSingularArgs>? = null

    private var slack: Output<FlowSourceFlowConfigSourceConnectorPropertiesSlackArgs>? = null

    private var trendmicro: Output<FlowSourceFlowConfigSourceConnectorPropertiesTrendmicroArgs>? =
        null

    private var veeva: Output<FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgs>? = null

    private var zendesk: Output<FlowSourceFlowConfigSourceConnectorPropertiesZendeskArgs>? = null

    /**
     * @param value Information that is required for querying Amplitude. See Generic Source Properties for more details.
     */
    @JvmName("cvlgqvojgevtjaxn")
    public suspend
    fun amplitude(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesAmplitudeArgs>) {
        this.amplitude = value
    }

    /**
     * @param value Properties that are applied when the custom connector is being used as a source. See Custom Connector Source Properties.
     */
    @JvmName("tfsnxgprkifjrvbo")
    public suspend
    fun customConnector(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgs>) {
        this.customConnector = value
    }

    /**
     * @param value Information that is required for querying Datadog. See Generic Source Properties for more details.
     */
    @JvmName("ihfptoyqdekpcdkg")
    public suspend
    fun datadog(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesDatadogArgs>) {
        this.datadog = value
    }

    /**
     * @param value Operation to be performed on the provided Dynatrace source fields. Valid values are `PROJECTION`, `BETWEEN`, `EQUAL_TO`, `ADDITION`, `MULTIPLICATION`, `DIVISION`, `SUBTRACTION`, `MASK_ALL`, `MASK_FIRST_N`, `MASK_LAST_N`, `VALIDATE_NON_NULL`, `VALIDATE_NON_ZERO`, `VALIDATE_NON_NEGATIVE`, `VALIDATE_NUMERIC`, and `NO_OP`.
     */
    @JvmName("hkwevyeykjopnuhy")
    public suspend
    fun dynatrace(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesDynatraceArgs>) {
        this.dynatrace = value
    }

    /**
     * @param value Operation to be performed on the provided Google Analytics source fields. Valid values are `PROJECTION` and `BETWEEN`.
     */
    @JvmName("njqkxungibiitqcd")
    public suspend
    fun googleAnalytics(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesGoogleAnalyticsArgs>) {
        this.googleAnalytics = value
    }

    /**
     * @param value Information that is required for querying Infor Nexus. See Generic Source Properties for more details.
     */
    @JvmName("dwthrcwjmvqchmvi")
    public suspend
    fun inforNexus(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesInforNexusArgs>) {
        this.inforNexus = value
    }

    /**
     * @param value Information that is required for querying Marketo. See Generic Source Properties for more details.
     */
    @JvmName("odovfflrsuocaeux")
    public suspend
    fun marketo(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesMarketoArgs>) {
        this.marketo = value
    }

    /**
     * @param value Information that is required for querying Amazon S3. See S3 Source Properties for more details.
     */
    @JvmName("chtfnepnjhlnuxjf")
    public suspend fun s3(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesS3Args>) {
        this.s3 = value
    }

    /**
     * @param value Information that is required for querying Salesforce. See Salesforce Source Properties for more details.
     */
    @JvmName("wydmkbvlynkhafkg")
    public suspend
    fun salesforce(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgs>) {
        this.salesforce = value
    }

    /**
     * @param value Information that is required for querying SAPOData as a flow source. See SAPO Source Properties for more details.
     */
    @JvmName("lkcvgaaubbyfnhtq")
    public suspend
    fun sapoData(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesSapoDataArgs>) {
        this.sapoData = value
    }

    /**
     * @param value Information that is required for querying ServiceNow. See Generic Source Properties for more details.
     */
    @JvmName("bfkgxwkjovomhgsy")
    public suspend
    fun serviceNow(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesServiceNowArgs>) {
        this.serviceNow = value
    }

    /**
     * @param value Information that is required for querying Singular. See Generic Source Properties for more details.
     */
    @JvmName("qofqykuwcveqltue")
    public suspend
    fun singular(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesSingularArgs>) {
        this.singular = value
    }

    /**
     * @param value Information that is required for querying Slack. See Generic Source Properties for more details.
     */
    @JvmName("ysypuwgngaxeukmf")
    public suspend
    fun slack(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesSlackArgs>) {
        this.slack = value
    }

    /**
     * @param value Operation to be performed on the provided Trend Micro source fields. Valid values are `PROJECTION`, `EQUAL_TO`, `ADDITION`, `MULTIPLICATION`, `DIVISION`, `SUBTRACTION`, `MASK_ALL`, `MASK_FIRST_N`, `MASK_LAST_N`, `VALIDATE_NON_NULL`, `VALIDATE_NON_ZERO`, `VALIDATE_NON_NEGATIVE`, `VALIDATE_NUMERIC`, and `NO_OP`.
     */
    @JvmName("uddjydikmoxhvarc")
    public suspend
    fun trendmicro(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesTrendmicroArgs>) {
        this.trendmicro = value
    }

    /**
     * @param value Information that is required for querying Veeva. See Veeva Source Properties for more details.
     */
    @JvmName("qjicxrtttavbxoos")
    public suspend
    fun veeva(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgs>) {
        this.veeva = value
    }

    /**
     * @param value Information that is required for querying Zendesk. See Generic Source Properties for more details.
     */
    @JvmName("cqhtopqrhxjhbjxi")
    public suspend
    fun zendesk(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesZendeskArgs>) {
        this.zendesk = value
    }

    /**
     * @param value Information that is required for querying Amplitude. See Generic Source Properties for more details.
     */
    @JvmName("plslvxitcwywudiw")
    public suspend
    fun amplitude(`value`: FlowSourceFlowConfigSourceConnectorPropertiesAmplitudeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amplitude = mapped
    }

    /**
     * @param argument Information that is required for querying Amplitude. See Generic Source Properties for more details.
     */
    @JvmName("dgeivpejsxvxglwm")
    public suspend
    fun amplitude(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesAmplitudeArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowSourceFlowConfigSourceConnectorPropertiesAmplitudeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.amplitude = mapped
    }

    /**
     * @param value Properties that are applied when the custom connector is being used as a source. See Custom Connector Source Properties.
     */
    @JvmName("nfutfqjjgqvopbun")
    public suspend
    fun customConnector(`value`: FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customConnector = mapped
    }

    /**
     * @param argument Properties that are applied when the custom connector is being used as a source. See Custom Connector Source Properties.
     */
    @JvmName("ogorfmpsbanffexr")
    public suspend
    fun customConnector(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customConnector = mapped
    }

    /**
     * @param value Information that is required for querying Datadog. See Generic Source Properties for more details.
     */
    @JvmName("ocdyvoflihxacpds")
    public suspend fun datadog(`value`: FlowSourceFlowConfigSourceConnectorPropertiesDatadogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datadog = mapped
    }

    /**
     * @param argument Information that is required for querying Datadog. See Generic Source Properties for more details.
     */
    @JvmName("lmcgsxyicuntgfyh")
    public suspend
    fun datadog(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesDatadogArgsBuilder.() -> Unit) {
        val toBeMapped = FlowSourceFlowConfigSourceConnectorPropertiesDatadogArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.datadog = mapped
    }

    /**
     * @param value Operation to be performed on the provided Dynatrace source fields. Valid values are `PROJECTION`, `BETWEEN`, `EQUAL_TO`, `ADDITION`, `MULTIPLICATION`, `DIVISION`, `SUBTRACTION`, `MASK_ALL`, `MASK_FIRST_N`, `MASK_LAST_N`, `VALIDATE_NON_NULL`, `VALIDATE_NON_ZERO`, `VALIDATE_NON_NEGATIVE`, `VALIDATE_NUMERIC`, and `NO_OP`.
     */
    @JvmName("godhparoxvovmppo")
    public suspend
    fun dynatrace(`value`: FlowSourceFlowConfigSourceConnectorPropertiesDynatraceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynatrace = mapped
    }

    /**
     * @param argument Operation to be performed on the provided Dynatrace source fields. Valid values are `PROJECTION`, `BETWEEN`, `EQUAL_TO`, `ADDITION`, `MULTIPLICATION`, `DIVISION`, `SUBTRACTION`, `MASK_ALL`, `MASK_FIRST_N`, `MASK_LAST_N`, `VALIDATE_NON_NULL`, `VALIDATE_NON_ZERO`, `VALIDATE_NON_NEGATIVE`, `VALIDATE_NUMERIC`, and `NO_OP`.
     */
    @JvmName("gmbeyuggmtehgphu")
    public suspend
    fun dynatrace(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesDynatraceArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowSourceFlowConfigSourceConnectorPropertiesDynatraceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dynatrace = mapped
    }

    /**
     * @param value Operation to be performed on the provided Google Analytics source fields. Valid values are `PROJECTION` and `BETWEEN`.
     */
    @JvmName("kbmtkpmskopjhlfc")
    public suspend
    fun googleAnalytics(`value`: FlowSourceFlowConfigSourceConnectorPropertiesGoogleAnalyticsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.googleAnalytics = mapped
    }

    /**
     * @param argument Operation to be performed on the provided Google Analytics source fields. Valid values are `PROJECTION` and `BETWEEN`.
     */
    @JvmName("hpcytcwhuutpghpp")
    public suspend
    fun googleAnalytics(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesGoogleAnalyticsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowSourceFlowConfigSourceConnectorPropertiesGoogleAnalyticsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.googleAnalytics = mapped
    }

    /**
     * @param value Information that is required for querying Infor Nexus. See Generic Source Properties for more details.
     */
    @JvmName("ctbrjceqnubnkmwa")
    public suspend
    fun inforNexus(`value`: FlowSourceFlowConfigSourceConnectorPropertiesInforNexusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inforNexus = mapped
    }

    /**
     * @param argument Information that is required for querying Infor Nexus. See Generic Source Properties for more details.
     */
    @JvmName("pwssepjoridcpikw")
    public suspend
    fun inforNexus(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesInforNexusArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowSourceFlowConfigSourceConnectorPropertiesInforNexusArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.inforNexus = mapped
    }

    /**
     * @param value Information that is required for querying Marketo. See Generic Source Properties for more details.
     */
    @JvmName("dbovidvvoekwjfse")
    public suspend fun marketo(`value`: FlowSourceFlowConfigSourceConnectorPropertiesMarketoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketo = mapped
    }

    /**
     * @param argument Information that is required for querying Marketo. See Generic Source Properties for more details.
     */
    @JvmName("uacmsxmlbshdywpi")
    public suspend
    fun marketo(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesMarketoArgsBuilder.() -> Unit) {
        val toBeMapped = FlowSourceFlowConfigSourceConnectorPropertiesMarketoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.marketo = mapped
    }

    /**
     * @param value Information that is required for querying Amazon S3. See S3 Source Properties for more details.
     */
    @JvmName("frnbapdpgvlvtaho")
    public suspend fun s3(`value`: FlowSourceFlowConfigSourceConnectorPropertiesS3Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument Information that is required for querying Amazon S3. See S3 Source Properties for more details.
     */
    @JvmName("hqiukkwlkpkypppt")
    public suspend
    fun s3(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesS3ArgsBuilder.() -> Unit) {
        val toBeMapped = FlowSourceFlowConfigSourceConnectorPropertiesS3ArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    /**
     * @param value Information that is required for querying Salesforce. See Salesforce Source Properties for more details.
     */
    @JvmName("kwirvjfhkrxowgmw")
    public suspend
    fun salesforce(`value`: FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.salesforce = mapped
    }

    /**
     * @param argument Information that is required for querying Salesforce. See Salesforce Source Properties for more details.
     */
    @JvmName("modvdihrguegwjjk")
    public suspend
    fun salesforce(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.salesforce = mapped
    }

    /**
     * @param value Information that is required for querying SAPOData as a flow source. See SAPO Source Properties for more details.
     */
    @JvmName("hrtjikgqklgpulfy")
    public suspend fun sapoData(`value`: FlowSourceFlowConfigSourceConnectorPropertiesSapoDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapoData = mapped
    }

    /**
     * @param argument Information that is required for querying SAPOData as a flow source. See SAPO Source Properties for more details.
     */
    @JvmName("mvwmsugubfvspnje")
    public suspend
    fun sapoData(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesSapoDataArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowSourceFlowConfigSourceConnectorPropertiesSapoDataArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sapoData = mapped
    }

    /**
     * @param value Information that is required for querying ServiceNow. See Generic Source Properties for more details.
     */
    @JvmName("jokthujijqlngpil")
    public suspend
    fun serviceNow(`value`: FlowSourceFlowConfigSourceConnectorPropertiesServiceNowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceNow = mapped
    }

    /**
     * @param argument Information that is required for querying ServiceNow. See Generic Source Properties for more details.
     */
    @JvmName("yotfucvyiaxiqjlo")
    public suspend
    fun serviceNow(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesServiceNowArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowSourceFlowConfigSourceConnectorPropertiesServiceNowArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.serviceNow = mapped
    }

    /**
     * @param value Information that is required for querying Singular. See Generic Source Properties for more details.
     */
    @JvmName("ydfhvehdqeneuogo")
    public suspend fun singular(`value`: FlowSourceFlowConfigSourceConnectorPropertiesSingularArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singular = mapped
    }

    /**
     * @param argument Information that is required for querying Singular. See Generic Source Properties for more details.
     */
    @JvmName("tqlyxagunaxhhypa")
    public suspend
    fun singular(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesSingularArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowSourceFlowConfigSourceConnectorPropertiesSingularArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singular = mapped
    }

    /**
     * @param value Information that is required for querying Slack. See Generic Source Properties for more details.
     */
    @JvmName("yxdehaekpbmacvop")
    public suspend fun slack(`value`: FlowSourceFlowConfigSourceConnectorPropertiesSlackArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slack = mapped
    }

    /**
     * @param argument Information that is required for querying Slack. See Generic Source Properties for more details.
     */
    @JvmName("rqocfkmfkvygcyom")
    public suspend
    fun slack(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesSlackArgsBuilder.() -> Unit) {
        val toBeMapped = FlowSourceFlowConfigSourceConnectorPropertiesSlackArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.slack = mapped
    }

    /**
     * @param value Operation to be performed on the provided Trend Micro source fields. Valid values are `PROJECTION`, `EQUAL_TO`, `ADDITION`, `MULTIPLICATION`, `DIVISION`, `SUBTRACTION`, `MASK_ALL`, `MASK_FIRST_N`, `MASK_LAST_N`, `VALIDATE_NON_NULL`, `VALIDATE_NON_ZERO`, `VALIDATE_NON_NEGATIVE`, `VALIDATE_NUMERIC`, and `NO_OP`.
     */
    @JvmName("cbtoavqpuxhjvhgo")
    public suspend
    fun trendmicro(`value`: FlowSourceFlowConfigSourceConnectorPropertiesTrendmicroArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trendmicro = mapped
    }

    /**
     * @param argument Operation to be performed on the provided Trend Micro source fields. Valid values are `PROJECTION`, `EQUAL_TO`, `ADDITION`, `MULTIPLICATION`, `DIVISION`, `SUBTRACTION`, `MASK_ALL`, `MASK_FIRST_N`, `MASK_LAST_N`, `VALIDATE_NON_NULL`, `VALIDATE_NON_ZERO`, `VALIDATE_NON_NEGATIVE`, `VALIDATE_NUMERIC`, and `NO_OP`.
     */
    @JvmName("wearobfakvbnlvnp")
    public suspend
    fun trendmicro(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesTrendmicroArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowSourceFlowConfigSourceConnectorPropertiesTrendmicroArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.trendmicro = mapped
    }

    /**
     * @param value Information that is required for querying Veeva. See Veeva Source Properties for more details.
     */
    @JvmName("dxxediocluhbaqyr")
    public suspend fun veeva(`value`: FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.veeva = mapped
    }

    /**
     * @param argument Information that is required for querying Veeva. See Veeva Source Properties for more details.
     */
    @JvmName("wnjhlnrcrqxluwfc")
    public suspend
    fun veeva(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgsBuilder.() -> Unit) {
        val toBeMapped = FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.veeva = mapped
    }

    /**
     * @param value Information that is required for querying Zendesk. See Generic Source Properties for more details.
     */
    @JvmName("luwdslogofrghuej")
    public suspend fun zendesk(`value`: FlowSourceFlowConfigSourceConnectorPropertiesZendeskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zendesk = mapped
    }

    /**
     * @param argument Information that is required for querying Zendesk. See Generic Source Properties for more details.
     */
    @JvmName("uckphoewpgnouvcs")
    public suspend
    fun zendesk(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesZendeskArgsBuilder.() -> Unit) {
        val toBeMapped = FlowSourceFlowConfigSourceConnectorPropertiesZendeskArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.zendesk = mapped
    }

    internal fun build(): FlowSourceFlowConfigSourceConnectorPropertiesArgs =
        FlowSourceFlowConfigSourceConnectorPropertiesArgs(
            amplitude = amplitude,
            customConnector = customConnector,
            datadog = datadog,
            dynatrace = dynatrace,
            googleAnalytics = googleAnalytics,
            inforNexus = inforNexus,
            marketo = marketo,
            s3 = s3,
            salesforce = salesforce,
            sapoData = sapoData,
            serviceNow = serviceNow,
            singular = singular,
            slack = slack,
            trendmicro = trendmicro,
            veeva = veeva,
            zendesk = zendesk,
        )
}
