@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property customProperties Custom properties that are specific to the connector when it's used as a destination in the flow. Maximum of 50 items.
 * @property entityName Entity specified in the custom connector as a destination in the flow.
 */
public data class FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgs(
    public val customProperties: Output<Map<String, String>>? = null,
    public val entityName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgs =
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgs.builder()
            .customProperties(
                customProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .entityName(entityName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgs].
 */
@PulumiTagMarker
public class FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgsBuilder internal
constructor() {
    private var customProperties: Output<Map<String, String>>? = null

    private var entityName: Output<String>? = null

    /**
     * @param value Custom properties that are specific to the connector when it's used as a destination in the flow. Maximum of 50 items.
     */
    @JvmName("dpnbtisctgtytdgl")
    public suspend fun customProperties(`value`: Output<Map<String, String>>) {
        this.customProperties = value
    }

    /**
     * @param value Entity specified in the custom connector as a destination in the flow.
     */
    @JvmName("djcirbtfbghmbgbf")
    public suspend fun entityName(`value`: Output<String>) {
        this.entityName = value
    }

    /**
     * @param value Custom properties that are specific to the connector when it's used as a destination in the flow. Maximum of 50 items.
     */
    @JvmName("lkeadqjhqdvhnggq")
    public suspend fun customProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param values Custom properties that are specific to the connector when it's used as a destination in the flow. Maximum of 50 items.
     */
    @JvmName("rfnmlqupnncoyufc")
    public fun customProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Entity specified in the custom connector as a destination in the flow.
     */
    @JvmName("iocxgnevrlguecpb")
    public suspend fun entityName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entityName = mapped
    }

    internal fun build(): FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgs =
        FlowSourceFlowConfigSourceConnectorPropertiesCustomConnectorArgs(
            customProperties = customProperties,
            entityName = entityName ?: throw PulumiNullFieldException("entityName"),
        )
}
