@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName Name of the Amazon S3 bucket.
 * @property bucketPrefix Amazon S3 bucket prefix.
 * @property s3InputFormatConfig When you use Amazon S3 as the source, the configuration format that you provide the flow input data. See S3 Input Format Config for details.
 */
public data class FlowSourceFlowConfigSourceConnectorPropertiesS3Args(
    public val bucketName: Output<String>,
    public val bucketPrefix: Output<String>? = null,
    public val s3InputFormatConfig:
    Output<FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesS3Args> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesS3Args =
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesS3Args.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .s3InputFormatConfig(
                s3InputFormatConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FlowSourceFlowConfigSourceConnectorPropertiesS3Args].
 */
@PulumiTagMarker
public class FlowSourceFlowConfigSourceConnectorPropertiesS3ArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var s3InputFormatConfig:
        Output<FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgs>? = null

    /**
     * @param value Name of the Amazon S3 bucket.
     */
    @JvmName("lncrorchkpuqqedg")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Amazon S3 bucket prefix.
     */
    @JvmName("bmheaayatrbovduf")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value When you use Amazon S3 as the source, the configuration format that you provide the flow input data. See S3 Input Format Config for details.
     */
    @JvmName("tbxhkirpelbbqjmr")
    public suspend
    fun s3InputFormatConfig(`value`: Output<FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgs>) {
        this.s3InputFormatConfig = value
    }

    /**
     * @param value Name of the Amazon S3 bucket.
     */
    @JvmName("iokccqqlrotueavx")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Amazon S3 bucket prefix.
     */
    @JvmName("ormlectkudyayvqi")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value When you use Amazon S3 as the source, the configuration format that you provide the flow input data. See S3 Input Format Config for details.
     */
    @JvmName("abutldihevydhjad")
    public suspend
    fun s3InputFormatConfig(`value`: FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3InputFormatConfig = mapped
    }

    /**
     * @param argument When you use Amazon S3 as the source, the configuration format that you provide the flow input data. See S3 Input Format Config for details.
     */
    @JvmName("ocdkylsqlwwpmvak")
    public suspend
    fun s3InputFormatConfig(argument: suspend FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3InputFormatConfig = mapped
    }

    internal fun build(): FlowSourceFlowConfigSourceConnectorPropertiesS3Args =
        FlowSourceFlowConfigSourceConnectorPropertiesS3Args(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            bucketPrefix = bucketPrefix,
            s3InputFormatConfig = s3InputFormatConfig,
        )
}
