@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableDynamicFieldUpdate Flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
 * @property includeDeletedRecords Whether Amazon AppFlow includes deleted files in the flow run.
 * @property object Object specified in the flow destination.
 */
public data class FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgs(
    public val enableDynamicFieldUpdate: Output<Boolean>? = null,
    public val includeDeletedRecords: Output<Boolean>? = null,
    public val `object`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgs =
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgs.builder()
            .enableDynamicFieldUpdate(enableDynamicFieldUpdate?.applyValue({ args0 -> args0 }))
            .includeDeletedRecords(includeDeletedRecords?.applyValue({ args0 -> args0 }))
            .`object`(`object`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgs].
 */
@PulumiTagMarker
public class FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgsBuilder internal
constructor() {
    private var enableDynamicFieldUpdate: Output<Boolean>? = null

    private var includeDeletedRecords: Output<Boolean>? = null

    private var `object`: Output<String>? = null

    /**
     * @param value Flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
     */
    @JvmName("losasifvjdjrgepk")
    public suspend fun enableDynamicFieldUpdate(`value`: Output<Boolean>) {
        this.enableDynamicFieldUpdate = value
    }

    /**
     * @param value Whether Amazon AppFlow includes deleted files in the flow run.
     */
    @JvmName("cnkvkaesdthuybwy")
    public suspend fun includeDeletedRecords(`value`: Output<Boolean>) {
        this.includeDeletedRecords = value
    }

    /**
     * @param value Object specified in the flow destination.
     */
    @JvmName("paownekesardbojp")
    public suspend fun `object`(`value`: Output<String>) {
        this.`object` = value
    }

    /**
     * @param value Flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
     */
    @JvmName("ewdkrcnkhihjhitq")
    public suspend fun enableDynamicFieldUpdate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDynamicFieldUpdate = mapped
    }

    /**
     * @param value Whether Amazon AppFlow includes deleted files in the flow run.
     */
    @JvmName("eammpqtvedmopddj")
    public suspend fun includeDeletedRecords(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeDeletedRecords = mapped
    }

    /**
     * @param value Object specified in the flow destination.
     */
    @JvmName("fumkmmigcmbtggkh")
    public suspend fun `object`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`object` = mapped
    }

    internal fun build(): FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgs =
        FlowSourceFlowConfigSourceConnectorPropertiesSalesforceArgs(
            enableDynamicFieldUpdate = enableDynamicFieldUpdate,
            includeDeletedRecords = includeDeletedRecords,
            `object` = `object` ?: throw PulumiNullFieldException("object"),
        )
}
