@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property documentType Document type specified in the Veeva document extract flow.
 * @property includeAllVersions Boolean value to include All Versions of files in Veeva document extract flow.
 * @property includeRenditions Boolean value to include file renditions in Veeva document extract flow.
 * @property includeSourceFiles Boolean value to include source files in Veeva document extract flow.
 * @property object Object specified in the flow destination.
 */
public data class FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgs(
    public val documentType: Output<String>? = null,
    public val includeAllVersions: Output<Boolean>? = null,
    public val includeRenditions: Output<Boolean>? = null,
    public val includeSourceFiles: Output<Boolean>? = null,
    public val `object`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgs =
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgs.builder()
            .documentType(documentType?.applyValue({ args0 -> args0 }))
            .includeAllVersions(includeAllVersions?.applyValue({ args0 -> args0 }))
            .includeRenditions(includeRenditions?.applyValue({ args0 -> args0 }))
            .includeSourceFiles(includeSourceFiles?.applyValue({ args0 -> args0 }))
            .`object`(`object`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgs].
 */
@PulumiTagMarker
public class FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgsBuilder internal constructor() {
    private var documentType: Output<String>? = null

    private var includeAllVersions: Output<Boolean>? = null

    private var includeRenditions: Output<Boolean>? = null

    private var includeSourceFiles: Output<Boolean>? = null

    private var `object`: Output<String>? = null

    /**
     * @param value Document type specified in the Veeva document extract flow.
     */
    @JvmName("asabldmtgrexycpd")
    public suspend fun documentType(`value`: Output<String>) {
        this.documentType = value
    }

    /**
     * @param value Boolean value to include All Versions of files in Veeva document extract flow.
     */
    @JvmName("seicfrmpenttiwnj")
    public suspend fun includeAllVersions(`value`: Output<Boolean>) {
        this.includeAllVersions = value
    }

    /**
     * @param value Boolean value to include file renditions in Veeva document extract flow.
     */
    @JvmName("uiiwinydmxlqnlqr")
    public suspend fun includeRenditions(`value`: Output<Boolean>) {
        this.includeRenditions = value
    }

    /**
     * @param value Boolean value to include source files in Veeva document extract flow.
     */
    @JvmName("kdbdalyrvdqhgwts")
    public suspend fun includeSourceFiles(`value`: Output<Boolean>) {
        this.includeSourceFiles = value
    }

    /**
     * @param value Object specified in the flow destination.
     */
    @JvmName("yuebgenmehypjgxq")
    public suspend fun `object`(`value`: Output<String>) {
        this.`object` = value
    }

    /**
     * @param value Document type specified in the Veeva document extract flow.
     */
    @JvmName("qraxwfagboferklv")
    public suspend fun documentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentType = mapped
    }

    /**
     * @param value Boolean value to include All Versions of files in Veeva document extract flow.
     */
    @JvmName("vttshatwgqhsoamb")
    public suspend fun includeAllVersions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeAllVersions = mapped
    }

    /**
     * @param value Boolean value to include file renditions in Veeva document extract flow.
     */
    @JvmName("ylywvncatnigiwih")
    public suspend fun includeRenditions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeRenditions = mapped
    }

    /**
     * @param value Boolean value to include source files in Veeva document extract flow.
     */
    @JvmName("qbepvxxfwhicajic")
    public suspend fun includeSourceFiles(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeSourceFiles = mapped
    }

    /**
     * @param value Object specified in the flow destination.
     */
    @JvmName("yabwrebaxpamkpri")
    public suspend fun `object`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`object` = mapped
    }

    internal fun build(): FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgs =
        FlowSourceFlowConfigSourceConnectorPropertiesVeevaArgs(
            documentType = documentType,
            includeAllVersions = includeAllVersions,
            includeRenditions = includeRenditions,
            includeSourceFiles = includeSourceFiles,
            `object` = `object` ?: throw PulumiNullFieldException("object"),
        )
}
