@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property amplitude The connector-specific credentials required when using Amplitude. See Amplitude Connector Profile Credentials for more details.
 * @property customConnector The connector-specific profile credentials required when using the custom connector. See Custom Connector Profile Credentials for more details.
 * @property datadog Connector-specific credentials required when using Datadog. See Datadog Connector Profile Credentials for more details.
 * @property dynatrace The connector-specific credentials required when using Dynatrace. See Dynatrace Connector Profile Credentials for more details.
 * @property googleAnalytics The connector-specific credentials required when using Google Analytics. See Google Analytics Connector Profile Credentials for more details.
 * @property honeycode The connector-specific credentials required when using Amazon Honeycode. See Honeycode Connector Profile Credentials for more details.
 * @property inforNexus The connector-specific credentials required when using Infor Nexus. See Infor Nexus Connector Profile Credentials for more details.
 * @property marketo Connector-specific credentials required when using Marketo. See Marketo Connector Profile Credentials for more details.
 * @property redshift Connector-specific credentials required when using Amazon Redshift. See Redshift Connector Profile Credentials for more details.
 * @property salesforce The connector-specific credentials required when using Salesforce. See Salesforce Connector Profile Credentials for more details.
 * @property sapoData The connector-specific credentials required when using SAPOData. See SAPOData Connector Profile Credentials for more details.
 * @property serviceNow The connector-specific credentials required when using ServiceNow. See ServiceNow Connector Profile Credentials for more details.
 * @property singular Connector-specific credentials required when using Singular. See Singular Connector Profile Credentials for more details.
 * @property slack Connector-specific credentials required when using Slack. See Slack Connector Profile Credentials for more details.
 * @property snowflake The connector-specific credentials required when using Snowflake. See Snowflake Connector Profile Credentials for more details.
 * @property trendmicro The connector-specific credentials required when using Trend Micro. See Trend Micro Connector Profile Credentials for more details.
 * @property veeva Connector-specific credentials required when using Veeva. See Veeva Connector Profile Credentials for more details.
 * @property zendesk Connector-specific credentials required when using Zendesk. See Zendesk Connector Profile Credentials for more details.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentials(
    public val amplitude: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitude? =
        null,
    public val customConnector:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnector? = null,
    public val datadog: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadog? =
        null,
    public val dynatrace: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatrace? =
        null,
    public val googleAnalytics:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsGoogleAnalytics? = null,
    public val honeycode: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycode? =
        null,
    public val inforNexus:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexus? = null,
    public val marketo: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketo? =
        null,
    public val redshift: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsRedshift? =
        null,
    public val salesforce:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforce? = null,
    public val sapoData: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoData? =
        null,
    public val serviceNow:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNow? = null,
    public val singular: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingular? =
        null,
    public val slack: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlack? = null,
    public val snowflake: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSnowflake? =
        null,
    public val trendmicro:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsTrendmicro? = null,
    public val veeva: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsVeeva? = null,
    public val zendesk: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendesk? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentials):
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentials =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentials(
                amplitude = javaType.amplitude().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitude.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                customConnector = javaType.customConnector().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnector.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                datadog = javaType.datadog().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadog.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                dynatrace = javaType.dynatrace().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatrace.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                googleAnalytics = javaType.googleAnalytics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsGoogleAnalytics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                honeycode = javaType.honeycode().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycode.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                inforNexus = javaType.inforNexus().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexus.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                marketo = javaType.marketo().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketo.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                redshift = javaType.redshift().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsRedshift.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                salesforce = javaType.salesforce().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforce.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sapoData = javaType.sapoData().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoData.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                serviceNow = javaType.serviceNow().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNow.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singular = javaType.singular().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingular.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                slack = javaType.slack().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlack.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                snowflake = javaType.snowflake().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSnowflake.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                trendmicro = javaType.trendmicro().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsTrendmicro.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                veeva = javaType.veeva().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsVeeva.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                zendesk = javaType.zendesk().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendesk.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
