@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiKey Unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
 * @property authenticationType The authentication type that the custom connector uses for authenticating while creating a connector profile. One of: `APIKEY`, `BASIC`, `CUSTOM`, `OAUTH2`.
 * @property basic Basic credentials that are required for the authentication of the user.
 * @property custom If the connector uses the custom authentication mechanism, this holds the required credentials.
 * @property oauth2 OAuth 2.0 credentials required for the authentication of the user.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnector(
    public val apiKey:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKey? =
        null,
    public val authenticationType: String,
    public val basic:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorBasic? = null,
    public val custom:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustom? =
        null,
    public val oauth2:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorOauth2? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnector):
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnector =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnector(
                apiKey = javaType.apiKey().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKey.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                authenticationType = javaType.authenticationType(),
                basic = javaType.basic().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorBasic.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                custom = javaType.custom().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustom.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                oauth2 = javaType.oauth2().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorOauth2.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
