@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiKey Unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
 * @property apiSecretKey The API secret key required for API key authentication.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKey(
    public val apiKey: String,
    public val apiSecretKey: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKey):
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKey =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKey(
                apiKey = javaType.apiKey(),
                apiSecretKey = javaType.apiSecretKey().map({ args0 -> args0 }).orElse(null),
            )
    }
}
