@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessToken The access token used to access the connector on your behalf.
 * @property clientCredentialsArn The secret manager ARN, which contains the client ID and client secret of the connected app.
 * @property jwtToken A JSON web token (JWT) that authorizes access to Salesforce records.
 * @property oauth2GrantType The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication. One of: `AUTHORIZATION_CODE`, `CLIENT_CREDENTIALS`.
 * @property oauthRequest Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
 * @property refreshToken The refresh token used to refresh an expired access token.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforce(
    public val accessToken: String? = null,
    public val clientCredentialsArn: String? = null,
    public val jwtToken: String? = null,
    public val oauth2GrantType: String? = null,
    public val oauthRequest:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequest? =
        null,
    public val refreshToken: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforce):
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforce =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforce(
                accessToken = javaType.accessToken().map({ args0 -> args0 }).orElse(null),
                clientCredentialsArn = javaType.clientCredentialsArn().map({ args0 -> args0 }).orElse(null),
                jwtToken = javaType.jwtToken().map({ args0 -> args0 }).orElse(null),
                oauth2GrantType = javaType.oauth2GrantType().map({ args0 -> args0 }).orElse(null),
                oauthRequest = javaType.oauthRequest().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequest.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                refreshToken = javaType.refreshToken().map({ args0 -> args0 }).orElse(null),
            )
    }
}
