@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessToken The access token used to access the connector on your behalf.
 * @property clientId The identifier for the desired client.
 * @property clientSecret The client secret used by the OAuth client to authenticate to the authorization server.
 * @property oauthRequest Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
 * @property refreshToken The refresh token used to refresh an expired access token.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentials(
    public val accessToken: String? = null,
    public val clientId: String,
    public val clientSecret: String,
    public val oauthRequest:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsOauthRequest? =
        null,
    public val refreshToken: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentials):
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentials =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentials(
                accessToken = javaType.accessToken().map({ args0 -> args0 }).orElse(null),
                clientId = javaType.clientId(),
                clientSecret = javaType.clientSecret(),
                oauthRequest = javaType.oauthRequest().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsOauthRequest.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                refreshToken = javaType.refreshToken().map({ args0 -> args0 }).orElse(null),
            )
    }
}
