@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessToken The access token used to access the connector on your behalf.
 * @property clientId The identifier for the desired client.
 * @property clientSecret The client secret used by the OAuth client to authenticate to the authorization server.
 * @property oauthRequest Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendesk(
    public val accessToken: String? = null,
    public val clientId: String,
    public val clientSecret: String,
    public val oauthRequest:
    ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskOauthRequest? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendesk):
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendesk =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendesk(
                accessToken = javaType.accessToken().map({ args0 -> args0 }).orElse(null),
                clientId = javaType.clientId(),
                clientSecret = javaType.clientSecret(),
                oauthRequest = javaType.oauthRequest().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskOauthRequest.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
