@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property oauth2Properties The OAuth 2.0 properties required for OAuth 2.0 authentication.
 * @property profileProperties A map of properties that are required to create a profile for the custom connector.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnector(
    public val oauth2Properties:
    ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2Properties? =
        null,
    public val profileProperties: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnector):
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnector =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnector(
                oauth2Properties = javaType.oauth2Properties().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2Properties.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                profileProperties = javaType.profileProperties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
