@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName A name for the associated Amazon S3 bucket.
 * @property bucketPrefix The object key for the destination bucket in which Amazon AppFlow places the files.
 * @property clusterIdentifier The unique ID that's assigned to an Amazon Redshift cluster.
 * @property dataApiRoleArn ARN of the IAM role that permits AppFlow to access the database through Data API.
 * @property databaseName The name of an Amazon Redshift database.
 * @property databaseUrl The JDBC URL of the Amazon Redshift cluster.
 * @property roleArn ARN of the IAM role.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshift(
    public val bucketName: String,
    public val bucketPrefix: String? = null,
    public val clusterIdentifier: String? = null,
    public val dataApiRoleArn: String? = null,
    public val databaseName: String? = null,
    public val databaseUrl: String? = null,
    public val roleArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshift):
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshift =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshift(
                bucketName = javaType.bucketName(),
                bucketPrefix = javaType.bucketPrefix().map({ args0 -> args0 }).orElse(null),
                clusterIdentifier = javaType.clusterIdentifier().map({ args0 -> args0 }).orElse(null),
                dataApiRoleArn = javaType.dataApiRoleArn().map({ args0 -> args0 }).orElse(null),
                databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
                databaseUrl = javaType.databaseUrl().map({ args0 -> args0 }).orElse(null),
                roleArn = javaType.roleArn(),
            )
    }
}
