@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property authCodeUrl The authorization code url required to redirect to SAP Login Page to fetch authorization code for OAuth type authentication.
 * @property oauthScopes The OAuth scopes required for OAuth type authentication.
 * @property tokenUrl The token URL required for OAuth 2.0 authentication.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthProperties(
    public val authCodeUrl: String,
    public val oauthScopes: List<String>,
    public val tokenUrl: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthProperties):
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthProperties =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthProperties(
                authCodeUrl = javaType.authCodeUrl(),
                oauthScopes = javaType.oauthScopes().map({ args0 -> args0 }),
                tokenUrl = javaType.tokenUrl(),
            )
    }
}
