@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiVersion API version that the destination connector uses.
 * @property connectorProfileName Name of the connector profile. This name must be unique for each connector profile in the AWS account.
 * @property connectorType Type of connector, such as Salesforce, Amplitude, and so on. Valid values are `Salesforce`, `Singular`, `Slack`, `Redshift`, `S3`, `Marketo`, `Googleanalytics`, `Zendesk`, `Servicenow`, `Datadog`, `Trendmicro`, `Snowflake`, `Dynatrace`, `Infornexus`, `Amplitude`, `Veeva`, `EventBridge`, `LookoutMetrics`, `Upsolver`, `Honeycode`, `CustomerProfiles`, `SAPOData`, and `CustomConnector`.
 * @property destinationConnectorProperties This stores the information that is required to query a particular connector. See Destination Connector Properties for more information.
 */
public data class FlowDestinationFlowConfig(
    public val apiVersion: String? = null,
    public val connectorProfileName: String? = null,
    public val connectorType: String,
    public val destinationConnectorProperties:
    FlowDestinationFlowConfigDestinationConnectorProperties,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfig):
            FlowDestinationFlowConfig = FlowDestinationFlowConfig(
            apiVersion = javaType.apiVersion().map({ args0 -> args0 }).orElse(null),
            connectorProfileName = javaType.connectorProfileName().map({ args0 -> args0 }).orElse(null),
            connectorType = javaType.connectorType(),
            destinationConnectorProperties = javaType.destinationConnectorProperties().let({ args0 ->
                com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorProperties.Companion.toKotlin(args0)
            }),
        )
    }
}
