@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property customProperties Custom properties that are specific to the connector when it's used as a destination in the flow. Maximum of 50 items.
 * @property entityName Entity specified in the custom connector as a destination in the flow.
 * @property errorHandlingConfig Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
 * @property idFieldNames Name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
 * @property writeOperationType Type of write operation to be performed in the custom connector when it's used as destination. Valid values are `INSERT`, `UPSERT`, `UPDATE`, and `DELETE`.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnector(
    public val customProperties: Map<String, String>? = null,
    public val entityName: String,
    public val errorHandlingConfig:
    FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorErrorHandlingConfig? =
        null,
    public val idFieldNames: List<String>? = null,
    public val writeOperationType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnector):
            FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnector =
            FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnector(
                customProperties = javaType.customProperties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                entityName = javaType.entityName(),
                errorHandlingConfig = javaType.errorHandlingConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnectorErrorHandlingConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                idFieldNames = javaType.idFieldNames().map({ args0 -> args0 }),
                writeOperationType = javaType.writeOperationType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
