@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domainName Unique name of the Amazon Connect Customer Profiles domain.
 * @property objectTypeName Object specified in the Amazon Connect Customer Profiles flow destination.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfiles(
    public val domainName: String,
    public val objectTypeName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfiles):
            FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfiles =
            FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfiles(
                domainName = javaType.domainName(),
                objectTypeName = javaType.objectTypeName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
