@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketPrefix Amazon S3 bucket prefix.
 * @property errorHandlingConfig Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
 * @property intermediateBucketName Intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift.
 * @property object Object specified in the flow destination.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesRedshift(
    public val bucketPrefix: String? = null,
    public val errorHandlingConfig:
    FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfig? = null,
    public val intermediateBucketName: String,
    public val `object`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshift):
            FlowDestinationFlowConfigDestinationConnectorPropertiesRedshift =
            FlowDestinationFlowConfigDestinationConnectorPropertiesRedshift(
                bucketPrefix = javaType.bucketPrefix().map({ args0 -> args0 }).orElse(null),
                errorHandlingConfig = javaType.errorHandlingConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                intermediateBucketName = javaType.intermediateBucketName(),
                `object` = javaType.`object`(),
            )
    }
}
