@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName Name of the Amazon S3 bucket.
 * @property bucketPrefix Amazon S3 bucket prefix.
 * @property s3OutputFormatConfig Configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination. See S3 Output Format Config for more details.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesS3(
    public val bucketName: String,
    public val bucketPrefix: String? = null,
    public val s3OutputFormatConfig:
    FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfig? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3):
            FlowDestinationFlowConfigDestinationConnectorPropertiesS3 =
            FlowDestinationFlowConfigDestinationConnectorPropertiesS3(
                bucketName = javaType.bucketName(),
                bucketPrefix = javaType.bucketPrefix().map({ args0 -> args0 }).orElse(null),
                s3OutputFormatConfig = javaType.s3OutputFormatConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
