@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property errorHandlingConfig Settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination. See Error Handling Config for more details.
 * @property idFieldNames Name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
 * @property object Object specified in the flow destination.
 * @property writeOperationType Type of write operation to be performed in the custom connector when it's used as destination. Valid values are `INSERT`, `UPSERT`, `UPDATE`, and `DELETE`.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforce(
    public val errorHandlingConfig:
    FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceErrorHandlingConfig? = null,
    public val idFieldNames: List<String>? = null,
    public val `object`: String,
    public val writeOperationType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforce):
            FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforce =
            FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforce(
                errorHandlingConfig = javaType.errorHandlingConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforceErrorHandlingConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                idFieldNames = javaType.idFieldNames().map({ args0 -> args0 }),
                `object` = javaType.`object`(),
                writeOperationType = javaType.writeOperationType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
