@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName Name of the Amazon S3 bucket.
 * @property bucketPrefix Amazon S3 bucket prefix.
 * @property s3OutputFormatConfig Configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination. See S3 Output Format Config for more details.
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolver(
    public val bucketName: String,
    public val bucketPrefix: String? = null,
    public val s3OutputFormatConfig:
    FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfig,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolver):
            FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolver =
            FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolver(
                bucketName = javaType.bucketName(),
                bucketPrefix = javaType.bucketPrefix().map({ args0 -> args0 }).orElse(null),
                s3OutputFormatConfig = javaType.s3OutputFormatConfig().let({ args0 ->
                    com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfig.Companion.toKotlin(args0)
                }),
            )
    }
}
