@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property customProperties Custom properties that are specific to the connector when it's used as a destination in the flow. Maximum of 50 items.
 * @property entityName Entity specified in the custom connector as a destination in the flow.
 */
public data class FlowSourceFlowConfigSourceConnectorPropertiesCustomConnector(
    public val customProperties: Map<String, String>? = null,
    public val entityName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowSourceFlowConfigSourceConnectorPropertiesCustomConnector):
            FlowSourceFlowConfigSourceConnectorPropertiesCustomConnector =
            FlowSourceFlowConfigSourceConnectorPropertiesCustomConnector(
                customProperties = javaType.customProperties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                entityName = javaType.entityName(),
            )
    }
}
