@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property documentType Document type specified in the Veeva document extract flow.
 * @property includeAllVersions Boolean value to include All Versions of files in Veeva document extract flow.
 * @property includeRenditions Boolean value to include file renditions in Veeva document extract flow.
 * @property includeSourceFiles Boolean value to include source files in Veeva document extract flow.
 * @property object Object specified in the flow destination.
 */
public data class FlowSourceFlowConfigSourceConnectorPropertiesVeeva(
    public val documentType: String? = null,
    public val includeAllVersions: Boolean? = null,
    public val includeRenditions: Boolean? = null,
    public val includeSourceFiles: Boolean? = null,
    public val `object`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowSourceFlowConfigSourceConnectorPropertiesVeeva):
            FlowSourceFlowConfigSourceConnectorPropertiesVeeva =
            FlowSourceFlowConfigSourceConnectorPropertiesVeeva(
                documentType = javaType.documentType().map({ args0 -> args0 }).orElse(null),
                includeAllVersions = javaType.includeAllVersions().map({ args0 -> args0 }).orElse(null),
                includeRenditions = javaType.includeRenditions().map({ args0 -> args0 }).orElse(null),
                includeSourceFiles = javaType.includeSourceFiles().map({ args0 -> args0 }).orElse(null),
                `object` = javaType.`object`(),
            )
    }
}
