@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property connectorOperators Operation to be performed on the provided source fields. See Connector Operator for details.
 * @property destinationField Field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
 * @property sourceFields Source fields to which a particular task is applied.
 * @property taskProperties Map used to store task-related information. The execution service looks for particular information based on the `TaskType`. Valid keys are `VALUE`, `VALUES`, `DATA_TYPE`, `UPPER_BOUND`, `LOWER_BOUND`, `SOURCE_DATA_TYPE`, `DESTINATION_DATA_TYPE`, `VALIDATION_ACTION`, `MASK_VALUE`, `MASK_LENGTH`, `TRUNCATE_LENGTH`, `MATH_OPERATION_FIELDS_ORDER`, `CONCAT_FORMAT`, `SUBFIELD_CATEGORY_MAP`, and `EXCLUDE_SOURCE_FIELDS_LIST`.
 * @property taskType Particular task implementation that Amazon AppFlow performs. Valid values are `Arithmetic`, `Filter`, `Map`, `Map_all`, `Mask`, `Merge`, `Passthrough`, `Truncate`, and `Validate`.
 */
public data class FlowTask(
    public val connectorOperators: List<FlowTaskConnectorOperator>? = null,
    public val destinationField: String? = null,
    public val sourceFields: List<String>,
    public val taskProperties: Map<String, String>? = null,
    public val taskType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowTask): FlowTask = FlowTask(
            connectorOperators = javaType.connectorOperators().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appflow.kotlin.outputs.FlowTaskConnectorOperator.Companion.toKotlin(args0)
                })
            }),
            destinationField = javaType.destinationField().map({ args0 -> args0 }).orElse(null),
            sourceFields = javaType.sourceFields().map({ args0 -> args0 }),
            taskProperties = javaType.taskProperties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            taskType = javaType.taskType(),
        )
    }
}
