@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property triggerProperties Configuration details of a schedule-triggered flow as defined by the user. Currently, these settings only apply to the `Scheduled` trigger type. See Scheduled Trigger Properties for details.
 * @property triggerType Type of flow trigger. Valid values are `Scheduled`, `Event`, and `OnDemand`.
 */
public data class FlowTriggerConfig(
    public val triggerProperties: FlowTriggerConfigTriggerProperties? = null,
    public val triggerType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowTriggerConfig):
            FlowTriggerConfig = FlowTriggerConfig(
            triggerProperties = javaType.triggerProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appflow.kotlin.outputs.FlowTriggerConfigTriggerProperties.Companion.toKotlin(args0)
                })
            }).orElse(null),
            triggerType = javaType.triggerType(),
        )
    }
}
