@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appintegrations.kotlin

import com.pulumi.aws.appintegrations.AppintegrationsFunctions.getEventIntegrationPlain
import com.pulumi.aws.appintegrations.kotlin.inputs.GetEventIntegrationPlainArgs
import com.pulumi.aws.appintegrations.kotlin.inputs.GetEventIntegrationPlainArgsBuilder
import com.pulumi.aws.appintegrations.kotlin.outputs.GetEventIntegrationResult
import com.pulumi.aws.appintegrations.kotlin.outputs.GetEventIntegrationResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

public object AppintegrationsFunctions {
    /**
     * Use this data source to get information on an existing AppIntegrations Event Integration.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appintegrations.AppintegrationsFunctions;
     * import com.pulumi.aws.appintegrations.inputs.GetEventIntegrationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AppintegrationsFunctions.getEventIntegration(GetEventIntegrationArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEventIntegration.
     * @return A collection of values returned by getEventIntegration.
     */
    public suspend fun getEventIntegration(argument: GetEventIntegrationPlainArgs):
        GetEventIntegrationResult = toKotlin(getEventIntegrationPlain(argument.toJava()).await())

    /**
     * @see [getEventIntegration].
     * @param name The AppIntegrations Event Integration name.
     * @param tags Metadata that you can assign to help organize the report plans you create.
     * @return A collection of values returned by getEventIntegration.
     */
    public suspend fun getEventIntegration(name: String, tags: Map<String, String>? = null):
        GetEventIntegrationResult {
        val argument = GetEventIntegrationPlainArgs(
            name = name,
            tags = tags,
        )
        return toKotlin(getEventIntegrationPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventIntegration].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appintegrations&#46;kotlin&#46;inputs&#46;GetEventIntegrationPlainArgs].
     * @return A collection of values returned by getEventIntegration.
     */
    public suspend
    fun getEventIntegration(argument: suspend GetEventIntegrationPlainArgsBuilder.() -> Unit):
        GetEventIntegrationResult {
        val builder = GetEventIntegrationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getEventIntegrationPlain(builtArgument.toJava()).await())
    }
}
