@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appintegrations.kotlin

import com.pulumi.aws.appintegrations.kotlin.outputs.DataIntegrationScheduleConfig
import com.pulumi.aws.appintegrations.kotlin.outputs.DataIntegrationScheduleConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DataIntegration].
 */
@PulumiTagMarker
public class DataIntegrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataIntegrationArgs = DataIntegrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataIntegrationArgsBuilder.() -> Unit) {
        val builder = DataIntegrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataIntegration {
        val builtJavaResource = com.pulumi.aws.appintegrations.DataIntegration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataIntegration(builtJavaResource)
    }
}

/**
 * Provides an Amazon AppIntegrations Data Integration resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appintegrations.DataIntegration;
 * import com.pulumi.aws.appintegrations.DataIntegrationArgs;
 * import com.pulumi.aws.appintegrations.inputs.DataIntegrationScheduleConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataIntegration("example", DataIntegrationArgs.builder()
 *             .description("example")
 *             .kmsKey(aws_kms_key.test().arn())
 *             .sourceUri("Salesforce://AppFlow/example")
 *             .scheduleConfig(DataIntegrationScheduleConfigArgs.builder()
 *                 .firstExecutionFrom("1439788442681")
 *                 .object("Account")
 *                 .scheduleExpression("rate(1 hour)")
 *                 .build())
 *             .tags(Map.of("Key1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon AppIntegrations Data Integrations using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:appintegrations/dataIntegration:DataIntegration example 12345678-1234-1234-1234-123456789123
 * ```
 *
 */
public class DataIntegration internal constructor(
    override val javaResource: com.pulumi.aws.appintegrations.DataIntegration,
) : KotlinCustomResource(javaResource, DataIntegrationMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Data Integration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies the description of the Data Integration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the KMS key Amazon Resource Name (ARN) for the Data Integration.
     */
    public val kmsKey: Output<String>
        get() = javaResource.kmsKey().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the Data Integration.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A block that defines the name of the data and how often it should be pulled from the source. The Schedule Config block is documented below.
     */
    public val scheduleConfig: Output<DataIntegrationScheduleConfig>
        get() = javaResource.scheduleConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Specifies the URI of the data source. Create an AppFlow Connector Profile and reference the name of the profile in the URL. An example of this value for Salesforce is `Salesforce://AppFlow/example` where `example` is the name of the AppFlow Connector Profile.
     */
    public val sourceUri: Output<String>
        get() = javaResource.sourceUri().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the Data Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DataIntegrationMapper : ResourceMapper<DataIntegration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appintegrations.DataIntegration::class == javaResource::class

    override fun map(javaResource: Resource): DataIntegration = DataIntegration(
        javaResource as
            com.pulumi.aws.appintegrations.DataIntegration,
    )
}

/**
 * @see [DataIntegration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataIntegration].
 */
public suspend fun dataIntegration(
    name: String,
    block: suspend DataIntegrationResourceBuilder.() -> Unit,
): DataIntegration {
    val builder = DataIntegrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataIntegration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataIntegration(name: String): DataIntegration {
    val builder = DataIntegrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
