@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appintegrations.kotlin

import com.pulumi.aws.appintegrations.DataIntegrationArgs.builder
import com.pulumi.aws.appintegrations.kotlin.inputs.DataIntegrationScheduleConfigArgs
import com.pulumi.aws.appintegrations.kotlin.inputs.DataIntegrationScheduleConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon AppIntegrations Data Integration resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appintegrations.DataIntegration;
 * import com.pulumi.aws.appintegrations.DataIntegrationArgs;
 * import com.pulumi.aws.appintegrations.inputs.DataIntegrationScheduleConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataIntegration("example", DataIntegrationArgs.builder()
 *             .description("example")
 *             .kmsKey(aws_kms_key.test().arn())
 *             .sourceUri("Salesforce://AppFlow/example")
 *             .scheduleConfig(DataIntegrationScheduleConfigArgs.builder()
 *                 .firstExecutionFrom("1439788442681")
 *                 .object("Account")
 *                 .scheduleExpression("rate(1 hour)")
 *                 .build())
 *             .tags(Map.of("Key1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon AppIntegrations Data Integrations using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:appintegrations/dataIntegration:DataIntegration example 12345678-1234-1234-1234-123456789123
 * ```
 * @property description Specifies the description of the Data Integration.
 * @property kmsKey Specifies the KMS key Amazon Resource Name (ARN) for the Data Integration.
 * @property name Specifies the name of the Data Integration.
 * @property scheduleConfig A block that defines the name of the data and how often it should be pulled from the source. The Schedule Config block is documented below.
 * @property sourceUri Specifies the URI of the data source. Create an AppFlow Connector Profile and reference the name of the profile in the URL. An example of this value for Salesforce is `Salesforce://AppFlow/example` where `example` is the name of the AppFlow Connector Profile.
 * @property tags Tags to apply to the Data Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DataIntegrationArgs(
    public val description: Output<String>? = null,
    public val kmsKey: Output<String>? = null,
    public val name: Output<String>? = null,
    public val scheduleConfig: Output<DataIntegrationScheduleConfigArgs>? = null,
    public val sourceUri: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appintegrations.DataIntegrationArgs> {
    override fun toJava(): com.pulumi.aws.appintegrations.DataIntegrationArgs =
        com.pulumi.aws.appintegrations.DataIntegrationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .kmsKey(kmsKey?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .scheduleConfig(scheduleConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceUri(sourceUri?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataIntegrationArgs].
 */
@PulumiTagMarker
public class DataIntegrationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var kmsKey: Output<String>? = null

    private var name: Output<String>? = null

    private var scheduleConfig: Output<DataIntegrationScheduleConfigArgs>? = null

    private var sourceUri: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the description of the Data Integration.
     */
    @JvmName("fwuojlsrksxmbmgn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the KMS key Amazon Resource Name (ARN) for the Data Integration.
     */
    @JvmName("hxonwlbmduedxldl")
    public suspend fun kmsKey(`value`: Output<String>) {
        this.kmsKey = value
    }

    /**
     * @param value Specifies the name of the Data Integration.
     */
    @JvmName("wkkkdokaimxqfbwk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A block that defines the name of the data and how often it should be pulled from the source. The Schedule Config block is documented below.
     */
    @JvmName("jtddxwonthnirmwa")
    public suspend fun scheduleConfig(`value`: Output<DataIntegrationScheduleConfigArgs>) {
        this.scheduleConfig = value
    }

    /**
     * @param value Specifies the URI of the data source. Create an AppFlow Connector Profile and reference the name of the profile in the URL. An example of this value for Salesforce is `Salesforce://AppFlow/example` where `example` is the name of the AppFlow Connector Profile.
     */
    @JvmName("fogfmgdgygidoqyh")
    public suspend fun sourceUri(`value`: Output<String>) {
        this.sourceUri = value
    }

    /**
     * @param value Tags to apply to the Data Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oconcccirtonbyhm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the description of the Data Integration.
     */
    @JvmName("butfulukacmmyklu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the KMS key Amazon Resource Name (ARN) for the Data Integration.
     */
    @JvmName("pgdhrwqhnbdeaewj")
    public suspend fun kmsKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKey = mapped
    }

    /**
     * @param value Specifies the name of the Data Integration.
     */
    @JvmName("qujiuqujktvugjck")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A block that defines the name of the data and how often it should be pulled from the source. The Schedule Config block is documented below.
     */
    @JvmName("wtmgopkjhebkxjco")
    public suspend fun scheduleConfig(`value`: DataIntegrationScheduleConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleConfig = mapped
    }

    /**
     * @param argument A block that defines the name of the data and how often it should be pulled from the source. The Schedule Config block is documented below.
     */
    @JvmName("esvkvsmuhdxahyem")
    public suspend
    fun scheduleConfig(argument: suspend DataIntegrationScheduleConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataIntegrationScheduleConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scheduleConfig = mapped
    }

    /**
     * @param value Specifies the URI of the data source. Create an AppFlow Connector Profile and reference the name of the profile in the URL. An example of this value for Salesforce is `Salesforce://AppFlow/example` where `example` is the name of the AppFlow Connector Profile.
     */
    @JvmName("tksekcyseiqidjxr")
    public suspend fun sourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceUri = mapped
    }

    /**
     * @param value Tags to apply to the Data Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("feheichdjvnqiexd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Data Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tkajykhocndjlnjf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataIntegrationArgs = DataIntegrationArgs(
        description = description,
        kmsKey = kmsKey,
        name = name,
        scheduleConfig = scheduleConfig,
        sourceUri = sourceUri,
        tags = tags,
    )
}
