@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appintegrations.kotlin.inputs

import com.pulumi.aws.appintegrations.inputs.GetEventIntegrationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEventIntegration.
 * @property name The AppIntegrations Event Integration name.
 * @property tags Metadata that you can assign to help organize the report plans you create.
 */
public data class GetEventIntegrationPlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appintegrations.inputs.GetEventIntegrationPlainArgs> {
    override fun toJava(): com.pulumi.aws.appintegrations.inputs.GetEventIntegrationPlainArgs =
        com.pulumi.aws.appintegrations.inputs.GetEventIntegrationPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetEventIntegrationPlainArgs].
 */
@PulumiTagMarker
public class GetEventIntegrationPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The AppIntegrations Event Integration name.
     */
    @JvmName("uluiokeofxxtrnvh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Metadata that you can assign to help organize the report plans you create.
     */
    @JvmName("dcijsktipmtgwmgg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Metadata that you can assign to help organize the report plans you create.
     */
    @JvmName("vjvmlqpjetaqpqef")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetEventIntegrationPlainArgs = GetEventIntegrationPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
