@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appintegrations.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property firstExecutionFrom The start date for objects to import in the first flow run as an Unix/epoch timestamp in milliseconds or in ISO-8601 format. This needs to be a time in the past, meaning that the data created or updated before this given date will not be downloaded.
 * @property object The name of the object to pull from the data source. Examples of objects in Salesforce include `Case`, `Account`, or `Lead`.
 * @property scheduleExpression How often the data should be pulled from data source. Examples include `rate(1 hour)`, `rate(3 hours)`, `rate(1 day)`.
 */
public data class DataIntegrationScheduleConfig(
    public val firstExecutionFrom: String,
    public val `object`: String,
    public val scheduleExpression: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appintegrations.outputs.DataIntegrationScheduleConfig):
            DataIntegrationScheduleConfig = DataIntegrationScheduleConfig(
            firstExecutionFrom = javaType.firstExecutionFrom(),
            `object` = javaType.`object`(),
            scheduleExpression = javaType.scheduleExpression(),
        )
    }
}
