@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appintegrations.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEventIntegration.
 * @property arn The ARN of the AppIntegrations Event Integration.
 * @property description The description of the Event Integration.
 * @property eventFilters A block that defines the configuration information for the event filter. The Event Filter block is documented below.
 * @property eventbridgeBus The EventBridge bus.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property tags Metadata that you can assign to help organize the report plans you create.
 */
public data class GetEventIntegrationResult(
    public val arn: String,
    public val description: String,
    public val eventFilters: List<GetEventIntegrationEventFilter>,
    public val eventbridgeBus: String,
    public val id: String,
    public val name: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appintegrations.outputs.GetEventIntegrationResult):
            GetEventIntegrationResult = GetEventIntegrationResult(
            arn = javaType.arn(),
            description = javaType.description(),
            eventFilters = javaType.eventFilters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appintegrations.kotlin.outputs.GetEventIntegrationEventFilter.Companion.toKotlin(args0)
                })
            }),
            eventbridgeBus = javaType.eventbridgeBus(),
            id = javaType.id(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
